#!/usr/bin/python3
#
# plot a gcode file using arrows in gnuplot, so can set style for each
# move, so can encode G0, G1, G2, G3 in the plot.

import sys, math

# convert arc to line segments
# this only works for G17 right now!!!!
def arc2lines(mode, plane, xs, ys, zs, xe, ye, ze, xoff, yoff, zoff, nrev):
  arc_res = 0.0002; # resolution of line segments for arc
  # mode = 3 is CW, 4 is CCW
  if mode == 3: ltr = "CW"
  if mode == 4: ltr = "CCW"
  radius = math.sqrt((xoff*xoff)+(yoff*yoff)+(zoff*zoff))
  centerx = xs + xoff;
  centery = ys + yoff;
  centerz = zs + zoff;
  if plane == 18: # XZ plane, default
    alpha_s = math.atan2((zs-centerz), (xs-centerx))
    alpha_e = math.atan2((ze-centerz), (xe-centerx))
    if math.fabs(alpha_s - alpha_e) < 1e-6: # same start, end angle ==> full rev
      alpha_e = alpha_s + 2*math.pi
    alpha_e = alpha_e + 2*math.pi*(nrev-1) # add extra revs
    npts = int(math.ceil(math.fabs(radius*(alpha_e-alpha_s))/arc_res))
    dalpha = (alpha_e - alpha_s)/npts;
    # ensure angle change correct for CW, CCW rotation
    if mode == 3: 
      if dalpha > 0: dalpha *= -1.0;
    else:
      if dalpha < 0: dalpha = math.fabs(dalpha)
    dy = (ye-ys)/npts;
    if settings.com:
      print("(CONVERT ARC TO LINES)")
    print("G1")
    for i in range(npts):
      alpha = alpha_s + (i+1)*dalpha
      x = centerx + math.cos(alpha)*radius
      y = ys + (i+1)*dy
      z = centerz + math.sin(alpha)*radius
      print("%9.4f %9.4f %9.4f %1d %s ARC"%
          (x, y, z, mode, ltr))
  if plane == 19: # YZ plane, default
    alpha_s = math.atan2((zs-centerz), (ys-centery))
    alpha_e = math.atan2((ze-centerz), (ye-centery))
    if math.fabs(alpha_s - alpha_e) < 1e-6: # same start, end angle ==> full rev
      alpha_e = alpha_s + 2*math.pi
    alpha_e = alpha_e + 2*math.pi*(nrev-1) # add extra revs
    npts = int(math.ceil(math.fabs(radius*(alpha_e-alpha_s))/arc_res))
    dalpha = (alpha_e - alpha_s)/npts;
    # ensure angle change correct for CW, CCW rotation
    if mode == 3: 
      if dalpha > 0: dalpha *= -1.0;
    else:
      if dalpha < 0: dalpha = math.fabs(dalpha)
    dx = (xe-xs)/npts;
    if settings.com:
      print("(CONVERT ARC TO LINES)")
    print("G1")
    for i in range(npts):
      alpha = alpha_s + (i+1)*dalpha
      x = xs + (i+1)*dx
      y = centery + math.cos(alpha)*radius
      z = centerz + math.sin(alpha)*radius
      print("%9.4f %9.4f %9.4f %1d %s ARC"%
          (x, y, z, mode, ltr))
  else: # XY plane, default
    alpha_s = math.atan2((ys-centery), (xs-centerx))
    alpha_e = math.atan2((ye-centery), (xe-centerx))
    if math.fabs(alpha_s - alpha_e) < 1e-6: # same start, end angle ==> full rev
      alpha_e = alpha_s + 2*math.pi
    alpha_e = alpha_e + 2*math.pi*(nrev-1) # add extra revs
    npts = int(math.ceil(math.fabs(radius*(alpha_e-alpha_s))/arc_res))
    dalpha = (alpha_e - alpha_s)/npts;
    # ensure angle change correct for CW, CCW rotation
    if mode == 3: 
      if dalpha > 0: dalpha *= -1.0;
    else:
      if dalpha < 0: dalpha = math.fabs(dalpha)
    dz = (ze-zs)/npts;
    if settings.com:
      print("(CONVERT ARC TO LINES)")
    print("G1")
    for i in range(npts):
      alpha = alpha_s + (i+1)*dalpha
      x = centerx + math.cos(alpha)*radius
      y = centery + math.sin(alpha)*radius
      z = zs + (i+1)*dz
      print("%9.4f %9.4f %9.4f %1d %s ARC"%
          (x, y, z, mode, ltr))

cx=0; cy=0; cz=0;
arc_cx = 0; arc_cy = 0; arc_cz = 0;
ox=0; oy=0; oz=0;
arc_ox = 0; arc_oy = 0; arc_oz = 0;
mode = 0; plane = 17;
print("#____X___ ____Y____ ____Z____ Mode")
for line in sys.stdin:
  flag = False; nrev=1;
  line = line.strip()
  if not line: continue
  if line[0] == "(": continue # comment line
  blocks = line.split()
  for j in range(len(blocks)):
    # skip all processing once comment found
    if blocks[j][0] == "(": 
      break;
    # check for letters in block after start ==> blocks run together, break apart
    for l in 'ABCDEFGHIJKLMNOPQRSTUVWXYZ':
      if l in blocks[j][1:]:
        [blocks[j], newblock] = blocks[j].split(l, 1)
        blocks.append("%c%s"%(l,newblock))

    if blocks[j] == '': # skip entry entry
      del blocks[j];
      continue
    ltr = blocks[j][0].upper()
    if ltr == 'X': cx = float(blocks[j][1:]); flag=True
    elif ltr == 'Y': cy = float(blocks[j][1:]); flag=True
    elif ltr == 'Z': cz = float(blocks[j][1:]); flag=True
    elif ltr == 'G':
      gn = int(blocks[j][1:])
      if gn < 4: # not a motion line, so drop line
        mode = gn+1 # movement mode change, add 1 for plotting
      elif gn == 17: plane = 17; break;
      elif gn == 18: plane = 18; break;
      elif gn == 19: plane = 19; break;
    elif ltr == 'I': arc_cx = float(blocks[j][1:]); flag=True
    elif ltr == 'J': arc_cy = float(blocks[j][1:]); flag=True
    elif ltr == 'K': arc_cz = float(blocks[j][1:]); flag=True
    elif ltr == 'P': nrev = int(blocks[j][1:]); flag=True;
    elif ltr == 'T': # tool change, break lines
      print(" ")
      break;
    else: # ignore other blocks
      continue
  if flag: # this is a move line
    if mode == 3 or mode == 4: # arc move (G2 = 3, G3 = 4), so replace with short line segments
      arc2lines(mode, plane, ox, oy, oz, cx, cy, cz, arc_cx, arc_cy, arc_cz, nrev)
    else:
      print("%9.4f %9.4f %9.4f %1d"%
        (cx, cy, cz, mode))
    ox=cx; oy=cy; oz=cz;
    arc_ox = arc_cx; arc_oy = arc_cy; arc_oz = arc_cz;

