#!/usr/bin/python3
#
# Remove problematic parts of G code file for VMC40 DNC
# Specificall, remove O line, sequence numbers, all comments, M2 or M30.

import sys

if len(sys.argv)<3:
  sys.stderr.write("usage: %s <input file> <out file>\n"%sys.argv[0])
  sys.exit(2)

inpf = open(sys.argv[1], "rt")
outf = open(sys.argv[2], "wt")

for line in inpf:
  outl = ""
  line = line.strip()
  if not line: continue
  if line[0] == "#": continue; # drop setup comments
  fields = line.split()
  for f in fields:
    if f[0] == "N": # sequence number, drop it
      continue
    elif f == "M2" or f == "M30":
      outl += "M0 "
    elif f[0] == "(": # start of comment, drop rest of line
      break
    else:
      outl += "%s "%f
  if outl:
    outf.write("%s\n"%outl)
inpf.close()
outf.close()

