#!/usr/bin/python3
#
# Find max, min X, Y, Z values per tool
# 
# Feed the script from stdin

import sys

tool = -1
minx = 99999.0; maxx = -99999.0;
miny = 99999.0; maxy = -99999.0;
minz = 99999.0; maxz = -99999.0;

for line in sys.stdin:
  line = line.strip()
  if not line: continue
  line = line.upper()
  F = line.split()

  for i in range(len(F)): # look for letters in fields
    f = F[i]
    if 'X' in f[1:]:
      j = f[1:].find('X')
      F.append(f[j+1:])
      F[i]=f[:f.rfind('X')]
    if 'Y' in f[1:]:
      j = f[1:].find('Y')
      F.append(f[j+1:])
      F[i]=f[:f.rfind('Y')]
    if 'Z' in f[1:]:
      j = f[1:].find('Z')
      F.append(f[j+1:])
      F[i]=f[:f.rfind('Z')]

  for f in F:
    if f[0] == "(": break; # next line
    if f == "G53":
      break; # next line, machine coords
    if f[0] == "X":
      v = float(f[1:])
      if v<minx: minx = v
      if v>maxx: maxx = v
    if f[0] == "Y":
      v = float(f[1:])
      if v<miny: miny = v
      if v>maxy: maxy = v
    if f[0] == "Z":
      v = float(f[1:])
      if v<minz: minz = v
      if v>maxz: maxz = v
    if f[0] == "T":
      v = int(f[1:])
      if v != tool and tool != -1:
        print("T%3d   X%9.4f - %9.4f  Y%9.4f - %9.4f  Z%9.4f - %9.4f"%(tool, minx, maxx, miny, maxy, minz, maxz))
        print("       ----------------------  ----------------------  ----------------------")
        minx = 99999.0; maxx = -99999.0;
        miny = 99999.0; maxy = -99999.0;
        minz = 99999.0; maxz = -99999.0;
      tool = v
print("T%3d   X%9.4f - %9.4f  Y%9.4f - %9.4f  Z%9.4f - %9.4f"%(tool, minx, maxx, miny, maxy, minz, maxz))
print("End of program")

