#!/usr/bin/python3
#
# Renumber lines in a DNC file, before sending.
# Ignore %, O lines; add new line number to all others, dropping
# existing line number blocks!
# Wraps at 9999 for MX3 limitations!

import sys

if len(sys.argv)<3:
  sys.stderr.write("usage: %s <input file> <out file> [start] [delta]\n"%sys.argv[0])
  sys.exit(2)

N0 = 2 # starting line number
delta = 2 # line number delta

inpf = open(sys.argv[1], "rt")
outf = open(sys.argv[2], "wt")

if len(sys.argv)>3:
  N0 = int(sys.argv[3])
if len(sys.argv)>4:
  delta = int(sys.argv[4])

N = N0
for line in inpf:
  outl = ""
  line = line.strip()
  if not line:
    continue
  fields = line.split()
  if fields[0][0] == "%": # skip line number for %, O lines
    outf.write("%s\n"%line)
    continue
  if fields[0][0] == "O":
    outf.write("%s\n"%line)
    continue
  if fields[0][0] == "#": # skip line number for # lines
    outf.write("%s\n"%line)
    continue
  outl = "N%04d "%N
  N += delta
  if N>9999:
    N = N0
  start = 0
  if fields[0][0] == "N":
    start=1
  for i in range(start,len(fields)):
    outl += "%s "%fields[i]
  if outl:
    outf.write("%s\n"%outl)
inpf.close()
outf.close()

