#!/usr/bin/python3
#
# Transform a gcode file by modifying coordinates.
# Read from stdin, print to stdout, modifying entries as we go....
import sys, math

xoffset = 0;
yoffset = 0;
zoffset = 0;
xmult = 1.0;
ymult = 1.0;
zmult = 1.0;

oldtool = -1;
newtool = -1;
oldspeed = -1;
newspeed = -1;
oldfeed = -1.0;
newfeed = -1.0;

if len(sys.argv) > 1:
  # parse args to find x forms
  for i in range(len(sys.argv)):
    a = sys.argv[i]
    if a == "-X": # addition to X coordinates
      i+=1
      xoffset = float(sys.argv[i])
    elif a == "-Y": # addition to Y coordinates
      i+=1
      yoffset = float(sys.argv[i])
    elif a == "-Z": # addition to Z coordinates
      i+=1
      zoffset = float(sys.argv[i])
    elif a == "-x": # multiplier to X coordinates
      i+=1
      xmult = float(sys.argv[i])
    elif a == "-y": # multiplier to Y coordinates
      i+=1
      ymult = float(sys.argv[i])
    elif a == "-z": # multiplier to Z coordinates
      i+=1
      zmult = float(sys.argv[i])
    elif a == "-t": # replace tool number
      i+=1
      oldtool = int(sys.argv[i])
      i+=1
      newtool = int(sys.argv[i])
    elif a == "-s": # replace spindle speeds
      i+=1
      oldspeed = int(sys.argv[i])
      i+=1
      newspeed = int(sys.argv[i])
    elif a == "-f": # replace feed rates
      i+=1
      oldfeed = float(sys.argv[i])
      i+=1
      newfeed = float(sys.argv[i])

for line in sys.stdin:
  line = line.strip()
  if not line: continue
  if line[0] == "(": print(line); continue # comment line
  if line[0] == ";": print(line); continue
  blocks = line.split()
  for j in range(len(blocks)):
    # skip all processing once comment found
    if blocks[j][0] == "(": 
      break;
    # check for letters in block ==> blocks run together, break apart
    for l in 'ABCDEFGHIJKLMNOPQRSTUVWXYZ':
      if l in blocks[j]:
        [blocks[j], newblock] = blocks[j].split(l, 1)
        blocks.append("%c%s"%(l,newblock))

    if blocks[j][0] == "X": # transform X
      v = float(blocks[j][1:])
      v += xoffset
      v *= xmult
      blocks[j] = "X+%.4f"%v

    elif blocks[j][0] == "Y":
      v = float(blocks[j][1:])
      v += yoffset
      v *= ymult
      blocks[j] = "Y+%.4f"%v

    elif blocks[j][0] == "Z":
      v = float(blocks[j][1:])
      v += zoffset
      v *= zmult
      blocks[j] = "Z+%.4f"%v

    elif blocks[j][0] == "T" and oldtool != -1:
      current = int(blocks[j][1:])
      if current == oldtool:
        blocks[j] = "T%d"%newtool
    elif blocks[j][0] == "H" and oldtool != -1:
      current = int(blocks[j][1:])
      if current == oldtool:
        blocks[j] = "H%d"%newtool

    elif blocks[j][0] == "S" and oldspeed != -1:
      current = int(blocks[j][1:])
      if current == oldspeed:
        blocks[j] = "S%d"%newspeed
    elif blocks[j][0] == "F" and oldfeed != -1.0:
      current = float(blocks[j][1:])
      if current == oldfeed:
        blocks[j] = "F%.4f"%newfeed

    else: continue
  print(' '.join(blocks))
