/*
 * matrix.h
 *
 * Header file for matrix.c
 * This has the data type and function definitions for the entries in
 * matrix.c
 *
 * This file is part of utah-g3d.
 *
 * utah-g3d is copyright (c) 2000, 2001 by
 * Paul Gettings,
 * Department of Geology & Geophysics,
 * University of Utah.
 *
 * All Rights Reserved.
 * 
 * utah-g3d is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License, version 2, as
 * published by the Free Software Foundation.
 * 
 * utah-g3d is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details, in the file
 * COPYING.  If that file is not present, write to the Free
 * Software Foundation, 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA
 * 
 */
#ifndef UG3D_MATRIX
#define UG3D_MATRIX

/*
 * Define a matrix structure for ease of use.
 *
 * This structure simplifies 2d matrix operations with doubles.
 * Mostly, use of a struct means the Matrix can keep track of size
 * information easily.
 */
typedef struct {
  unsigned long m;
  unsigned long n;
  double **array;
  } Matrix;

double sign(double a, double b);
Matrix newMatrix(unsigned long m, unsigned long n);
Matrix makeMatrix(double **a, unsigned long m, unsigned long n);
void delMatrix(Matrix M);
double **allocateArray(unsigned long m, unsigned long n);
double *allocateVector(unsigned long l);
int copyArray(double **src, double **dst, unsigned long m, unsigned long n);
int copyMatrix(Matrix src, Matrix dst);
Matrix eye(unsigned long m);
int printMatrix(Matrix m);
int printArray(double **a, unsigned long m, unsigned long n);
int mscale(Matrix a, double scale);
int rscale(Matrix a, unsigned long row, double scale);
int cscale(Matrix a, unsigned long col, double scale);
int mm(Matrix a, Matrix b, Matrix c);
int ma(Matrix a, Matrix b, Matrix c);
int ms(Matrix a, Matrix b, Matrix c);
int transpose(Matrix a, Matrix aT);
int ludecomp(Matrix M, int *indx);
int lubacksub(Matrix M, int *indx, double *b);
int inv(Matrix M, Matrix Mi);
#endif
