#!/usr/bin/python
#
# generate_horiz_grid.py
#
# Generate a regular grid of x,y,z points for computing gravity
# anomalies
#
# This file is part of utah-g3d.
#
# utah-g3d is copyright (c) 2000 by
# Paul Gettings,
# Department of Geology & Geophysics,
# University of Utah.
#
# All Rights Reserved.
# 
# utah-g3d is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License, version 2, as
# published by the Free Software Foundation.
# 
# utah-g3d is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details, in the file
# COPYING.  If that file is not present, write to the Free
# Software Foundation, 59 Temple Place - Suite 330, Boston, MA  
# 02111-1307, USA

import sys

if len(sys.argv) < 8:
  print "usage: %s xstart dx xend ystart dy yend z"%sys.argv[0];
  sys.exit(0);

xstart = float(sys.argv[1]);
dx     = float(sys.argv[2]);
xend   = float(sys.argv[3]);
ystart = float(sys.argv[4]);
dy     = float(sys.argv[5]);
yend   = float(sys.argv[6]);
z      = float(sys.argv[7]);

#print "# Automatically generated by %s"%sys.argv[0]
x = xstart;
# outer loop is x
while x<=xend:
  y = ystart;
  while y<=yend:
    print "%f %f %f"%(x, y, z);
    y = y + dy;
  x = x + dx;
#print "# done"
