/*
 * genModel.h
 *
 * header file for genModel.c; some other files need the functions in
 * genModel
 *
 * This file is part of utah-g3d.
 *
 * utah-g3d is copyright (c) 2000 by
 * Paul Gettings,
 * Department of Geology & Geophysics,
 * University of Utah.
 *
 * All Rights Reserved.
 * 
 * utah-g3d is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License, version 2, as
 * published by the Free Software Foundation.
 * 
 * utah-g3d is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details, in the file
 * COPYING.  If that file is not present, write to the Free
 * Software Foundation, 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA
 * 
 */
#ifndef GENMODEL_H
#define GENMODEL_H
#ifndef FALSE
#define FALSE	0
#endif
#ifndef TRUE
#define TRUE	1
#endif

typedef struct BlockStruct {
  Element elem;
  void *next;
  void *prev;
  char flag;		/* if TRUE, write to file */
  } BlockList;

void uppercase(char *string);
BlockList *allocateBlock(void *p);
BlockList *setBlock(double x, double y, double z, double p,
			double xs, double ys, double zs,
			BlockList *block);
BlockList *blockify_block(double X, double Y, double Z, double p, double xs,
				double ys, double zs, double xlen, double ylen,
				double zlen, BlockList *blocks);
BlockList *blockify_sphere(double X, double Y, double Z, double r, double p,
				double xlen, double ylen, double zlen,
				BlockList *blocks);
BlockList *blockify_hdisc(double X, double Y, double Z, double r, double h,
				double p, double xlen, double ylen,
				double zlen, BlockList *blocks);
BlockList *delDuplicate(BlockList *block);

#endif
