/*
 * gaussrand.h
 *
 * normal distribution pseudo-random number generator
 *
 * Based on a uniform distribution PRNG, that is then mapped to a
 * normal distribution.
 *
 * Currently requires the Mersenne Twister PRNG in mt.c; could be
 * easily modified to use any uniform distribution PRNG - change the
 * calls to genrand() and sgenrand() in gaussrand.c
 *
 * init_gaussrand() initializes the MT PRNG from /dev/random
 * getseed() returns the current seed of the MT PRNG
 * setseed() sets the seed of the MT PRNG; use this if you don't
 * 		have /dev/random, and find someplace to get a random
 *		unsigned long int
 * gaussrand() returns a random double in the range [0,1); it calls
 *		genrand() twice, and could produce 2 numbers per call;
 *		the line to compute the second number is commented out.
 *
 * This file is part of utah-g3d.
 *
 * utah-g3d is copyright (c) 2000, 2001 by
 * Paul Gettings,
 * Department of Geology & Geophysics,
 * University of Utah.
 *
 * All Rights Reserved.
 * 
 * utah-g3d is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License, version 2, as
 * published by the Free Software Foundation.
 * 
 * utah-g3d is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details, in the file
 * COPYING.  If that file is not present, write to the Free
 * Software Foundation, 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA
 * 
 */
#ifndef GAUSS_RAND
#define GAUSS_RAND

void init_gaussrand(void);
unsigned long getseed(void);
void setseed(unsigned long seed);
double gaussrand(double mean, double sigma);

#endif
