/*
 * gaussrand.c
 * 
 * normal distribution Pseudo-Random Number Generator
 *
 * see gaussrand.h for copyright, description, etc.
 *
 * This file is part of utah-g3d.
 *
 * utah-g3d is copyright (c) 2000,2001 by
 * Paul Gettings,
 * Department of Geology & Geophysics,
 * University of Utah.
 *
 * All Rights Reserved.
 * 
 * utah-g3d is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License, version 2, as
 * published by the Free Software Foundation.
 * 
 * utah-g3d is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details, in the file
 * COPYING.  If that file is not present, write to the Free
 * Software Foundation, 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA
 * 
 */
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <math.h>
#include "gaussrand.h"
#include "mt.h"

unsigned long gaussrand_seed;

unsigned long getseed(void)
{
  return gaussrand_seed;
}

void setseed(unsigned long seed)
{
  gaussrand_seed = seed;
  sgenrand(gaussrand_seed);
}

void init_gaussrand(void)
{
  int fd, count;
  unsigned long *buf;

  if((buf = (unsigned long *)calloc(1, sizeof(unsigned long int))) == NULL) {
    fprintf(stderr, "init_gaussrand: cannot allocate and clear memory for buffer.\n");
    exit(1);
    }

  if((fd = open("/dev/random", O_RDONLY)) == -1) {
    fprintf(stderr, "init_gaussrand: cannot open /dev/random for read.\n");
    exit(1);
    }

  count = read(fd, (void *)buf, sizeof(unsigned long int));
  if(count != sizeof(unsigned long int)) {
    fprintf(stderr, "init_gaussrand: cannot get enough random bits for seed.\n");
    exit(1);
    }
  close(fd);

  gaussrand_seed = *buf;

  sgenrand(gaussrand_seed);
}

double gaussrand(double mean, double sigma)
{
  /* normal dist. RNG */
  double x1, x2, w, y1, y2;
  do {
    x1 = 2.0 * genrand() - 1.0;
    x2 = 2.0 * genrand() - 1.0;
    w = x1 * x1 + x2 * x2;
    } while (w >= 1.0);
  w = sqrt( (-2.0 * log( w ) ) / w );
  y1 = x1 * w * sigma + mean;
/*y2 = x2 * w + mean; */
  
  return(y1);
}

