/*
 * blocktree.h
 *
 * header file for blocktree.c
 *
 * This file is part of utah-g3d.
 *
 * utah-g3d is copyright (c) 2000 by
 * Paul Gettings,
 * Department of Geology & Geophysics,
 * University of Utah.
 *
 * All Rights Reserved.
 * 
 * utah-g3d is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License, version 2, as
 * published by the Free Software Foundation.
 * 
 * utah-g3d is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details, in the file
 * COPYING.  If that file is not present, write to the Free
 * Software Foundation, 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA
 * 
 */
#ifndef BLOCKTREE_H
#define BLOCKTREE_H

#include "model.h"
#include "genModel.h"


typedef struct TreeStruct {
  void *branches[8];
  char Leaf;	/* 1 if leaf node */
  } BlockTree;

typedef struct RangeStruct {
  double xmax, xmin;
  double ymax, ymin;
  double zmax, zmin;
  double minResX;
  double minResY;
  double minResZ;
  } Range;

BlockTree *allocateBranch();
BlockTree *genBlockTree(BlockList *blocks);
BlockList *blockTreeToList(BlockTree *tree);
int insertLeaf(BlockList block, BlockTree *tree, Range r);
BlockList *traverseTree(BlockTree *tree, BlockList *blocks);

#endif
