#!/usr/bin/python

# make a file of timestamps (YYYY/MM/DD HH:MM:SS), one per line
# starting a specified date, moving forward delta time, ending at
# second date/time.

import jd
import sys

if len(sys.argv)<6:
  print "usage: %s start_date start_time delta end_date end_time"
  print "where dates are YYYY/MM/DD, times are HH:MM:SS, delta in seconds"
  sys.exit(1)


start = jd.str2jd(sys.argv[1], sys.argv[2])
end = jd.str2jd(sys.argv[4], sys.argv[5])
delta = float(sys.argv[3]) / (24*3600); # seconds to days

now = start
while now <= end:
  print jd.datestr(now)
  now = now + delta
