#!/usr/bin/python
#
# Create a file of dates, times for use in building Earth Tide tables.

import sys
import jd

if len(sys.argv) < 6:
  print "usage: %s <start_date> <start_time> <delta> <end_date> <end_time>"%sys.argv[0]
  print "dates are in YYYY/MM/DD format, time in HH:MM, delta in seconds"
  sys.exit(1)


start = jd.str2jd(sys.argv[1], "%s:00"%sys.argv[2])
stop = jd.str2jd(sys.argv[4], "%s:00"%sys.argv[5])
delta = float(sys.argv[3])

if delta <= 0:
  print "delta must be positive!"
  sys.exit(2)

if stop < start:
  print "stop time must be after start!"
  sys.exit(3)

delta /= 86400;	# convert from seconds to days
time=start
while time<=stop:
  print jd.datestr(time)
  time += delta;

