#!/usr/bin/python
#
# Sort a date, grav, sigma file by date, assuming standard format of
# year/mo/dy
#

import sys, jd

if len(sys.argv)<2:
  filename=None;
else:
  filename = sys.argv[1];

if filename:
  file = open(filename, "rt");
else:
  file = sys.stdin;

lines = file.readlines()
if filename: file.close()

data = {}

for line in lines:
  line = line.strip()
  if not line: continue;
  if line[0]=="#": continue;
  (date, sid, grav, sigma) = line.split()
  time = jd.str2jd(date, "13:00:00");
  data[time] = (float(grav), float(sigma), sid)

if filename:
  file = open(filename, "wt");
else:
  file = sys.stdout;

times = data.keys()
times.sort()
for t in times:
  (date, time) = jd.datestr(t).split()
  file.write("%10s %15s %.3f %.3f\n"%(date, data[t][2], data[t][0], data[t][1]))
