# tkplot - simple 2-D plotting package for Tkinter
# only does linear 2-axis plot
# extensions are welcome

import math
from Tkinter import *

class Point:
  def __init__(self):
    self.x = 0.0
    self.y = 0.0

class tkplot:
  def __init__(self, master, H, W, bg, fg, **grid_args):
#
# The following entries define the appearance of the plot
#
    self.tick_size = 3
    self.tagsize = 8
    self.nprec = 3
    self.border = 5
    self.title = ""
    self.xlabel = ""
    # numeric = numbered ticvals
    # time = Time strings ==> ticvals are decimal days
    self.xlabeltype = "numeric"
    self.ylabel = ""
    self.Nxtick = 10	# number of big (labeled) ticks on x axis
    self.Nytick = 10	# number of big (labeled) ticks on y axis
    self.xstart = 0
    self.xo = 0
    self.xend = 0
    self.ystart = 0
    self.yo = 0
    self.yend = 0
    self.color = fg
    self.axis_color = fg
#
# DO NOT ALTER THESE BY HAND!  THEY ARE COMPUTED FROM WINDOW INFORMATION
# AND THE INFORMATION IN THE SECTION BELOW!
#
    self.__root = master
    self.__root.configure(background=bg, height=H, width=W)
    self.__canvas = Canvas(self.__root, background=bg, height=H, width=W)
  # grid the canvas, using passed grid args
    self.show(grid_args)
  # bind a handler for resize events - you can resize the window and the
  # plot will be redrawn to the new size!
    self.__root.bind("<Configure>", self.resize)
    self.__xaxis_start = 5
    self.__xaxis_end = 635
    self.__yaxis_start = 5
    self.__yaxis_end = 475

    self.__data = []
    self.__pstyle = []
    self.__lstyle = []
    self.__yline = []
    self.__y_lstyle = []
    self.__labels = []
    self.__l_color = []
    self.__color = []
    self.__y_color = []
    self.__drawFlag = 0	# if 0, nothing has been plotted
    self.__xtics = 1	# if 0, don't draw x axis tics
    self.__ytics = 1	# if 0, don't draw y axis tics

  def resize(self, event):
    # window changed size, so need to redraw the plot, using the new size
    # turn off event handler for the configuration
    self.__root.unbind("<Configure>")

    # set canvas to new window size
    self.__canvas.configure(height=event.height, width=event.width)

    # redraw contents
    self.redraw()

    # reset event handler
    self.__root.bind("<Configure>", self.resize)

  def redraw(self):
    # clear the canvas
    self.clearcanvas()

    if self.__drawFlag == 0:
      # do nothing
      return

    # redraw axes
    self.draw_axes()
    # redraw all the data plots
    for i in range(len(self.__data)):
      self.color = self.__color[i]
      self.draw_plot(self.__data[i], self.__lstyle[i], self.__pstyle[i])
    # redraw constant lines
    for i in range(len(self.__yline)):
      self.color = self.__y_color[i]
      self.draw_consty_line(self.__yline[i], self.__y_lstyle[i])
    # redraw labels
    for i in range(len(self.__labels)):
      self.color = self.__l_color[i]
      self.draw_label(self.__labels[i])

  def show(self, grid_args={}):
    # grid the canvas, using the args passed
    self.__canvas.grid(grid_args)

  def set_alarm(self):
    # every 500 ms, wake up and update the plot
    self.update()
    self.__canvas.after(500, self.set_alarm)

  def xaxis(self, y, xstart, xo, delx, lor):
    # y - constant y offset of axis
    # xstart - user unit value of start of axis
    # xo - user value of first labelled tick
    # delx - user value of distance between labelled tics
    # lor - if 'r', draw on right; if 'l', draw on left
    # adapted from C code xyplot.i by Mark Gettings, 1990
    # draws on self.__canvas
    xi = self.__xaxis_start
    xf = self.__xaxis_end
    ticsize = self.tick_size
    delbigtic = self.x_del_big
    dellittletic = self.x_del_ltl
    nprec = self.nprec

    format = "%0.0f"

    if lor == 'l':
      ticsize = -ticsize

    ymax = int(self.__canvas.cget("height"))
    if nprec >= 0 and self.__xtics:
      format = "%%%d.%df" % (self.tagsize, nprec)
      textheight = self.labelheight
    else:
      textheight = 0
    # draw the axis line
    axis = self.__canvas.create_line(xi, ymax-y, xf, ymax-y, fill=self.color)
    # draw the tics
    factor = delbigtic/delx
    xxf = (xo-xstart)*factor + xi
    x1 = xxf
    xx = xxf
    while xx >= xi:
      xxf = xxf - dellittletic
      xx = xxf
    xxf = xxf+dellittletic
    xx = xxf
    # little ticks
    while int(xx) <= int(xf):
      if self.__xtics:
	self.__canvas.create_line(xx, ymax-y, xx, ymax-(y-ticsize), fill=self.color)
      xxf = xxf + dellittletic
      xx = xxf
    xx=x1
    xxf = x1
    yy = ymax-(y-3*ticsize+int(textheight/2))
    ticval = xo
    # Big ticks
    while int(xx) <= int(xf):
      if self.__xtics:
	self.__canvas.create_line(xx, ymax-y, xx, ymax-(y-2*ticsize), fill=self.color)
      if nprec >= 0 and self.__xtics:
	# check for label type - numeric or time
	if self.xlabeltype == "time":
	  labelstr = self.num2time(ticval)
	else:
	  labelstr = format % (ticval,)
	self.__canvas.create_text(xx, yy, text=labelstr, fill=self.color, anchor=N)
      xxf = xxf + delbigtic
      xx = xxf
      ticval = ticval + delx
  # end xaxis

  def yaxis(self, x, ystart, yo, dely, lor):
    # x - constant x position of axis
    # ystart - user unit value of start of axis
    # yo - user value of first labelled tick
    # dely - user value of distance between labelled tics
    # lor - if "l", draws ticks on left; if "r", draw on right
    # adapted from C code xyplot.i by Mark Gettings, 1990
    # draws on self.__canvas
    yi = self.__yaxis_start
    yf = self.__yaxis_end
    ticsize = self.tick_size
    dellittletic = self.y_del_ltl
    delbigtic = self.y_del_big
    nprec = self.nprec

    # compute bounding box of a maximum label
    if nprec >= 0 and self.__ytics:
      format = "%%%d.%df" % (self.tagsize, self.nprec)
      textwidth = self.labelwidth
    else:
      format = "%0.0f"
      textwidth = 0

    if lor == 'r':
      ticsize = -ticsize

    ymax = int(self.__canvas.cget("height"))
    # draw the axis line
    axis = self.__canvas.create_line(x, ymax-yi, x, ymax-yf, fill=self.color)
    # draw the tics
    factor = delbigtic/dely
    yyf = (yo-ystart)*factor + yi
    y1 = yyf
    yy = yyf
    while yy >= yi:
      yyf = yyf - dellittletic
      yy = yyf
    yyf = yyf+dellittletic
    yy = yyf
    # Little ticks
    while int(yy) <= int(yf):
      if self.__ytics:
	self.__canvas.create_line(x, ymax-yy, x-ticsize, ymax-yy, fill=self.color)
      yyf = yyf + dellittletic
      yy = yyf
    yy=y1
    yyf = y1
    yyy = ymax-yy
    ticval = yo
    xx = x - (3*ticsize)
    # Big ticks
    while int(yy) <= int(yf):
      if self.__ytics:
	self.__canvas.create_line(x, ymax-yy, x-2*ticsize, ymax-yy, fill=self.color)
      if nprec >= 0 and self.__ytics:
	labelstr = format % (ticval,)
	self.__canvas.create_text(xx, yyy, text=labelstr, fill=self.color, anchor=E, justify=RIGHT)
      yyf = yyf + delbigtic
      yy = yyf
      yyy = ymax - yy
      ticval = ticval + dely
# end yaxis

  def draw_axes(self):
    # first, setup bounds of axis box, then draw/label axes on plot

    # clear the canvas
    self.__canvas.delete(ALL)

    # get size of bbox of maximum label size
    self.__canvas.create_text(0,0,text="."+"2"*self.tagsize,tags="bbox",fill="black")
    coords = self.__canvas.bbox("bbox")
    self.__canvas.delete("bbox")
    textwidth = coords[2] - coords[0]
    textheight = coords[3] - coords[1]

    # set the axis limits
    self.labelwidth = textwidth
    self.labelheight = textheight
    self.__xaxis_start = self.border + self.tick_size*3
    if self.__ytics: # add space for tics and labels, if plotting
      self.__xaxis_start += textwidth
    else:
      self.__xaxis_start += textwidth/2;
    self.__yaxis_start = self.border + self.tick_size*3
    if self.__xtics: # add space for tics and labels, if plotting
      self.__yaxis_start = textheight
    else:
      self.__yaxis_start = textheight/2
    self.__xaxis_end = int(self.__canvas.cget("width")) - (self.tick_size*3 + self.border)
    ymax = int(self.__canvas.cget("height"))
    self.__yaxis_end = ymax - (self.tick_size*3 + self.border)

    # reserve space for the title
    self.__canvas.create_text(0,0,text=self.title,tags="title", anchor=CENTER, justify=CENTER)
    coords = self.__canvas.bbox("title")
    self.__canvas.delete("title")
    titleheight = coords[3] - coords[1]
    self.__yaxis_end = self.__yaxis_end - titleheight

    # reserve space for x and y-axis labels
    # x-axis label, on bottom
    self.__canvas.create_text(0,0,text=self.xlabel,tags="xlabel", anchor=N, justify=CENTER)
    coords = self.__canvas.bbox("xlabel")
    self.__canvas.delete("xlabel")
    xlabelheight = coords[3] - coords[1]
    self.__yaxis_start = self.__yaxis_start + xlabelheight

    # y-axis label - see if taller than titleheight
    self.__canvas.create_text(0,0,text=self.ylabel,tags="ylabel", anchor=S, justify=CENTER)
    coords = self.__canvas.bbox("ylabel")
    self.__canvas.delete("ylabel")
    ylabelheight = coords[3] - coords[1]
    ylabelwidth = coords[2] - coords[0]
    if ylabelheight > titleheight:
      self.__yaxis_end = self.__yaxis_end + titleheight
      self.__yaxis_end = self.__yaxis_end - ylabelheight

    # compute deltas
    if self.xlabeltype == "time":
      xtickstr = self.num2time(self.xend)
    else:
      xtickstr = str(self.xend)
    self.__canvas.create_text(0,0,text=xtickstr,tags="xlabel", anchor=N, justify=CENTER)
    coords = self.__canvas.bbox("xlabel")
    self.__canvas.delete("xlabel")
    xlabelwidth = coords[2] - coords[0] + 10
    ylabelheight = coords[3] - coords[1] + 10

    ppdux = float((self.__xaxis_end - self.__xaxis_start))/(self.xend - self.xstart)
    ppduy = float((self.__yaxis_end - self.__yaxis_start))/(self.yend - self.ystart)
    self.Nxtick = self.Nxtick + 1
    self.x_del_big = xlabelwidth - 1
    while self.x_del_big < xlabelwidth:
      self.Nxtick= self.Nxtick - 1
      self.delx = (self.xend - self.xstart) / float(self.Nxtick)
      self.x_del_big = int(ppdux*self.delx)
      if self.Nxtick == 1:
	# minimum # of ticks, regardless
	break
    self.Nytick = self.Nytick + 1
    self.y_del_big = ylabelheight - 1
    while self.y_del_big < ylabelheight:
      self.Nytick= self.Nytick - 1
      self.dely = (self.yend - self.ystart) / float(self.Nytick)
      self.y_del_big = int(ppduy*self.dely)
      if self.Nytick == 1:
	# minimum # of ticks, regardless
	break
    self.x_del_ltl = self.get_ltl_tick(self.x_del_big)
    self.y_del_ltl = self.get_ltl_tick(self.y_del_big)

    # draw the axes
    self.color = self.axis_color
    self.xaxis(self.__yaxis_start, self.xstart, self.xo, self.delx, "r")
    self.yaxis(self.__xaxis_start, self.ystart, self.yo, self.dely, "l")
    np = self.nprec
    self.nprec = -1
    self.xaxis(self.__yaxis_end, self.xstart, self.xo, self.delx, "l")
    self.yaxis(self.__xaxis_end, self.ystart, self.yo, self.dely, "r")
    self.nprec = np

    # put up the title/labels
    xx = (self.__xaxis_end + self.__xaxis_start) / 2
    yy = ymax - (self.__yaxis_end + titleheight/2 + 3*self.tick_size)
    self.__canvas.create_text(xx, yy, text=self.title, fill=self.color, tags="title")
    xx = (self.border + ylabelwidth/2)
    yy = ymax - (self.__yaxis_end + ylabelheight/2 + 3*self.tick_size)
    self.__canvas.create_text(xx, yy, text=self.ylabel, fill=self.color, tags="ylabel")
    yy = ymax - (self.__yaxis_start - 3*self.tick_size - self.labelheight)
    xx = (self.__xaxis_end + self.__xaxis_start) / 2
    self.__canvas.create_text(xx, yy, text=self.xlabel, fill=self.color, tags="xlabel", anchor=N)

    # End draw_axes

###############################################################################
## plot_data - Plot (x,y) pairs contained in data[].x and data[].y
## ptstyle parameter determines if a point if plotted at each data location
## current known values:
##	None - no points
## 	any unknown value is plotted as text at the point position
## linestyle par. determines if the points are connected by a line
## currently known values:
##	None - no lines
##	"-" - solid line
##	"1" - 12% gray stipple
##	"2" - 25% gray stipple
##	"3" - 50% gray stipple
##	"4" - 75% gray stipple
## 	any unknown value turns off lines
## set the plot color by changing self.color
###############################################################################
  def plot_data(self, data, linestyle, ptstyle):
    # copy incoming data, so we can regenerate plot at will
    self.__data.append(data)
    self.__pstyle.append(ptstyle)
    self.__lstyle.append(linestyle)
    self.__color.append(self.color)

    # draw the plot
    if not self.__drawFlag:
      # if nothing drawn before, draw axes
      self.draw_axes()
    self.color = self.__color[-1]
    self.draw_plot(self.__data[-1], self.__lstyle[-1], self.__pstyle[-1])

    self.__drawFlag = 1

  def draw_plot(self, data, linestyle, ptstyle):
    # plot the data in data.  Assume that data is a list of data[].x and
    # data[].y
    # plot data[].y vs. data[].x

    ymax = int(self.__canvas.cget("height"))

    # scaling factors
    # given self.x|ystart, etc. we can compute scaling factors for the data
    xfactor = self.x_del_big / self.delx
    yfactor = self.y_del_big / self.dely

    # plot each point
    ox = "none"
    for i in range(len(data)):
      xx = (data[i].x - self.xstart) * xfactor + self.__xaxis_start
      yy = (data[i].y - self.ystart) * yfactor + self.__yaxis_start
      yy = ymax - yy
      if ptstyle != "None" and ptstyle != None:
	self.__canvas.create_text(xx, yy, text=ptstyle, anchor=CENTER, fill=self.color)
      if ox == "none":
	ox = xx
	oy = yy
      self.draw_line(ox, oy, xx, yy, linestyle)
      ox = xx
      oy = yy

    # end draw_plot

###############################################################################
## plot_consty_line(val, linestyle) - Plot a line of constant y value on the plot
###############################################################################
  def plot_consty_line(self, val, linestyle):
    # add the value and linestyle to self.__yline
    self.__yline.append(val)
    self.__y_lstyle.append(linestyle)
    self.__y_color.append(self.color)

    # draw the line
    if not self.__drawFlag:
      # if nothing drawn before, draw axes
      self.draw_axes()
    self.draw_consty_line(self.__yline[-1], self.__y_lstyle[-1])

    self.__drawFlag = 1

  def draw_consty_line(self, val, linestyle):
    ymax = int(self.__canvas.cget("height"))

    # scaling factors
    # given self.x|ystart, etc. we can compute scaling factors for the data
    yfactor = self.y_del_big / self.dely

    yy = (val - self.ystart) * yfactor + self.__yaxis_start
    yy = ymax - yy
    self.draw_line(self.__xaxis_start, yy, self.__xaxis_end, yy, linestyle)

  def draw_line(self, ox, oy, xx, yy, linestyle):
    if ox == "none":
      ox = xx; oy = yy
    if linestyle == "None":
      return
    if linestyle == "-":
      self.__canvas.create_line(ox, oy, xx, yy, fill=self.color)
    if linestyle == "1":
      self.__canvas.create_line(ox, oy, xx, yy, fill=self.color, stipple="gray12")
    if linestyle == "2":
      self.__canvas.create_line(ox, oy, xx, yy, fill=self.color, stipple="gray25")
    if linestyle == "3":
      self.__canvas.create_line(ox, oy, xx, yy, fill=self.color, stipple="gray50")
    if linestyle == "4":
      self.__canvas.create_line(ox, oy, xx, yy, fill=self.color, stipple="gray75")
    return

###############################################################################
# plot_label
# draw an arbitrary label on the plot at position x,y in user units
# label attributes added to the self.__labels array
###############################################################################
  def plot_label(self, x, y, labelstr, font="default", justify=LEFT, anchor=W):
    incoming = Point()
    incoming.x = x
    incoming.y = y
    incoming.string = labelstr
    incoming.font = font
    incoming.justify = justify
    incoming.anchor = anchor
    self.__l_color.append(self.color)
    self.__labels.append(incoming)

    if not self.__drawFlag:
      # if nothing drawn before, draw axes
      self.draw_axes()

    self.draw_label(self.__labels[-1])

    self.__drawFlag = 1

  def draw_label(self, label):
    ymax = int(self.__canvas.cget("height"))
    # scaling factors
    # given self.x|ystart, etc. we can compute scaling factors for the data
    xfactor = self.x_del_big / self.delx
    yfactor = self.y_del_big / self.dely
    xx = (label.x - self.xstart) * xfactor + self.__xaxis_start
    yy = (label.y - self.ystart) * yfactor + self.__yaxis_start
    yy = ymax - yy
    if label.font != "default":
      self.__canvas.create_text(xx, yy, text=label.string,
	anchor=label.anchor, justify=label.justify, fill=self.color, font=label.font)
    else:
      self.__canvas.create_text(xx, yy, text=label.string,
	anchor=label.anchor, justify=label.justify, fill=self.color)


  def get_ltl_tick(self, big_tick):
    div = [50, 20, 10, 5, 2]

    for i in range(6):
      if i == 5:
	ltltic = big_tick
	break
      ltltic = big_tick/div[i]
      if ltltic >= 20:
	break
    return ltltic

  def ps_print(self, fname, cmode, landscape):
    # produce postscript output of canvas
    # note that this uses the Tk postscript function
    # cmode should be one of: "color", "gray", or "mono"
    # landscape should be one of: 1 or 0 (portrait)
    # fname should be filename to write output to
    self.__canvas.postscript(file=fname, colormode=cmode, rotate=landscape)

  def postscript(self, cmode, landscape):
    # produce postscript output, and return as string
    return self.__canvas.postscript(colormode=cmode, rotate=landscape)

  def get_mouse(self, event):
    # get the mouse x and y
    ymax = int(self.__canvas.cget("height"))
    self.mousex = self.__canvas.canvasx(event.x) - self.__xaxis_start
    self.mousey = (ymax - self.__canvas.canvasy(event.y)) - self.__yaxis_start
    self.__canvas.quit()

  def get_mouse_click(self, n_clicks):
    # get n_clicks mouse clicks, and return user unit values, not pixels
    ymax = int(self.__canvas.cget("height"))
    xfactor = self.delx / self.x_del_big
    yfactor = self.dely / self.y_del_big

    incoming = Point()
    x = []
    y = []
    self.__canvas.bind("<ButtonRelease-1>", self.get_mouse)
    for i in range(n_clicks):
      self.__canvas.mainloop()
      x.append(self.mousex * xfactor + self.xstart)
      y.append(self.mousey * yfactor + self.ystart)
    return (x,y)

  def update(self):
    self.__canvas.update()

  def clearplot(self):
    # remove all items on the canvas, and clear the data
    # matrices
    self.clearcanvas()
    self.__data = []
    self.__pstyle = []
    self.__lstyle = []
    self.__color = []
    self.__yline = []
    self.__y_lstyle = []
    self.__y_color = []
    self.__labels = []
    self.__l_color = []
    self.__drawFlag = 0

  def clearcanvas(self):
    # clear all items on the canvas
    self.__canvas.delete(ALL)
    self.update()

  def refresh(self):
    event = Point()
    event.height = int(self.__canvas.cget("height"))
    event.width = int(self.__canvas.cget("width"))
    self.resize(event)

  def mainloop(self):
    self.__canvas.mainloop()

  def quit(self):
    self.__canvas.quit()

  def num2time(self, time):
    # convert decimal day into time string
    sign = 1;
    if time<0:
      sign = -1;
      time *= -1;
    a = time*24.0
    hours = math.floor(a)
    b = (a - hours) * 60.0
    minutes = math.floor(b)
    seconds = int(round((b - minutes)*60.0))

    # prettify the output
    if seconds == 60:
      seconds = 0; minutes = minutes+1
    if minutes == 60:
      minutes = 0; hours = hours+1

    s="%d:%02d:%02d" % (hours, minutes, seconds)
    if sign < 0:
      s="-%s"%s;
    return s

  def autoscale(self, data, nxtics, nytics):
    self.Nxtick = nxtics
    self.Nytick = nytics
    xmax = data[0].x
    ymax = data[0].y
    xmin = data[0].x
    ymin = data[0].y
    for i in range(len(data)):
      if data[i].x > xmax:
	xmax = data[i].x
      if data[i].x < xmin:
	xmin = data[i].x
      if data[i].y > ymax:
	ymax = data[i].y
      if data[i].y < ymin:
	ymin = data[i].y
    # check for pre-existing data
    for j in range(len(self.__data)):
      for i in range(len(self.__data[j])):
	if self.__data[j][i].x > xmax:
	  xmax = self.__data[j][i].x
	if self.__data[j][i].x < xmin:
	  xmin = self.__data[j][i].x
	if self.__data[j][i].y > ymax:
	  ymax = self.__data[j][i].y
	if self.__data[j][i].y < ymin:
	  ymin = self.__data[j][i].y

    dx = (xmax - xmin)/float(self.Nxtick)
    # trap for dx=0 ==> log10 = -Inf!
    if dx == 0.0:
      dx = 1.0
    O = int(math.log10(dx))
    A = 0.5*pow(10.0, O)
    O = O*-1
    self.xstart = round(xmin-A, O)
    self.xend = round(xmax+A, O)
    dy = (ymax - ymin)/float(self.Nytick)
    # trap for dy=0 ==> log10 = -Inf!
    if dy == 0.0:
      dy = 1.0
    O = int(math.log10(dy))
    A = 0.5*pow(10.0, O)
    O = O*-1
    self.ystart = round(ymin-A, O)
    self.yend = round(ymax+A, O)
    return

  # turn on/off drawing of y axis tics
  def ytics(self, flag):
    self.__ytics = flag

  def xtics(self, flag):
    self.__xtics = flag

  # compute the current height of text on the canvas
  def textheight(self):
    self.__canvas.create_text(0,0,text="."+"2"*self.tagsize,tags="bbox",fill="black")
    coords = self.__canvas.bbox("bbox")
    self.__canvas.delete("bbox")
    textheight = coords[3] - coords[1]
    self.labelheight = textheight
    return self.labelheight

  def sort_data(self, data):
    data.sort(time_sort)

  # sort on x part of a, b so we can sort data arrays
  def x_sort(self, a, b):
    try:
      A = float(a.x)
    except ValueError:
      # not a valid float string, so assign it -0.01
      # this way, it is less than 0.0 and before all positive numbers
      A = -0.01
    try:
      B = float(b.x)
    except ValueError:
      B = -0.01

    if A < B:
      return -1
    elif A > B:
      return 1
    else: return 0

