# Correct the meter tilt correction using xe, ye
# where xe/ye are the errors in zero level determined by the "Zero
# error" procedure in the manual
import math

# the formulas for T (and hence Tc) are taken straight from the "Theory
# of Operation" section of the CG-3 manual.  See Appendix A.

def correct(data, xe, ye):
  # data is the raw_data from the CG-3, no averaging
  # xe/ye are the errors in arcseconds
  # convert from arc-seconds to radians
  G = 980600.000 # 980.6 Gal
  Xe = arcsec2rad(xe)
  Ye = arcsec2rad(ye)
  for i in range(len(data)):
    X = arcsec2rad(data[i].tilt_x)
    Y = arcsec2rad(data[i].tilt_y)
    dT = G*(math.cos(X)*math.cos(Y) - math.cos(X+Xe)*math.cos(Y+Ye))
    data[i].gravity = data[i].gravity + dT

def arcsec2rad(A):
  D = A/3600.0
  R = D * math.pi/180.0
  return R
