#!/usr/bin/python
#
# Replace an entry in file 1 with entry in file 2 by station name
#
import sys

if len(sys.argv)<3:
  sys.stderr.write("usage: %s <orig_file> <replace_file>\n"%sys.argv[0])
  sys.exit(2);

new={}
file=open(sys.argv[2], "rt")
for line in file:
  line=line.strip()
  if not line: continue;
  if line[0]=="#": continue;
  fields=line.split(None,1);
  new[fields[0]] = line; # store whole line for output
file.close()

replaced={}
file=open(sys.argv[1], "rt")
for line in file:
  line=line.strip()
  if not line: continue;
  if line[0]=="#": print line; continue; # preserve comments
  (name, toss)=line.split(None,1);
  if name in new: # in replacement file, replace record
    print "# replaced next line"
    print new[name]
    replaced[name]=1;
  else:
    print line
file.close()

# output un-replaced stations
for key in new.keys():
  if key not in replaced:
    print new[key]
