#!/usr/bin/python

# compare UTEP DB file (reformatted downloaded file) to output from uGrav TC calcs

import sys

# sys.argv[1] == UTEP station database converted from downloaded file
# sys.argv[2] == uGrav terrain correction output
file=open(sys.argv[1], "rt");
utep={}
for line in file:
  line=line.strip();
  if not line: continue;
  if line[0]=="#": continue;
  fields=line.split()
  name=fields[0];
  lat=float(fields[2]);
  lon=float(fields[1]);
  elev=float(fields[3]);
  grav=float(fields[4]);
  iztc=float(fields[6]);
  ttc=float(fields[7]);
  utep[name] = ttc;
file.close()

file=open(sys.argv[2], "rt");
for line in file:
  line=line.strip()
  if not line: continue;
  if line[0]=="#": continue;
  fields = line.split();
  name=fields[0];
  lon = float(fields[1]);
  lat = float(fields[2]);
  ele = float(fields[3]);
  ttc=float(fields[7]);
  if name in utep:
    print "%-25s %11.6f %11.6f %8.3f %10.6f %10.6f %10.6f"%(name,
      lon, lat, ele, ttc-utep[name], ttc, utep[name]);
file.close()
