#!/usr/bin/python

# compare downloaded UTEP files to output from uGrav TC calcs

import sys

# sys.argv[1] == UTEP station listing from website
# sys.argv[2] == uGrav terrain correction output
file=open(sys.argv[1], "rt");
file.readline(); # skip first 3 lines....
file.readline();
file.readline();
utep={}
for line in file:
  fields=line.split()
  lat=float(fields[2]);
  lon=float(fields[4]);
  elev=float(fields[6]);
  grav=float(fields[7])+976000.0;
  iztc=float(fields[8]);
  oztc=float(fields[9]);
  utep["%.6f_%.6f"%(lon,lat)] = iztc+oztc;
file.close()

file=open(sys.argv[2], "rt");
for line in file:
  line=line.strip()
  if not line: continue;
  if line[0]=="#": continue;
  fields = line.split();
  name=fields[0];
  lon = float(fields[1]);
  lat = float(fields[2]);
  ele = float(fields[3]);
  ttc=float(fields[7]);
  key="%.6f_%.6f"%(lon,lat)
  if key in utep:
    print "%-25s %11.6f %11.6f %8.3f %10.6f %10.6f %10.6f"%(name,
      lon, lat, ele, ttc-utep[key], ttc, utep[key]);
file.close()
