#!/usr/bin/python

# read pfact format file from USGS TC program, and compare
# numbers from micrograv-src terrain correction output.

import sys

if len(sys.argv)<3:
  sys.stderr.write("usage: %s <usgs_file> <ugrav_tc_file>\n"%sys.argv[0]);
  sys.exit(1);

usgs={}
file=open(sys.argv[1], "rt");
for line in file:
  line=line.strip()
  if not line: continue;
  if line[0]=="#": continue;
  fields = line.split();
  name=fields[0];
  lat=float(fields[1]); sign=1.0;
  if lat<0: sign=-1.0;
  lat = lat+(sign * float(fields[2])/60.0);
  lon=float(fields[4]); sign=1.0;
  if lon<0: sign=-1.0;
  lon = lon+(sign * float(fields[5])/60.0);
  ttc=float(fields[13]);
  usgs[name]=(lon,lat,ttc);
file.close();

print "#Station_name               Longitude    Latitude Ele_mASL   TC_diff  uGrav_ttc   USGS_ttc"

file=open(sys.argv[2], "rt");
for line in file:
  line=line.strip()
  if not line: continue;
  if line[0]=="#": continue;
  fields = line.split();
  name=fields[0];
  lon = float(fields[1]);
  lat = float(fields[2]);
  ele = float(fields[3]);
  ttc=float(fields[7]);
  if name in usgs:
    print "%-25s %11.6f %11.6f %8.3f %10.6f %10.6f %10.6f"%(name,
      lon, lat, ele, ttc-usgs[name][2], ttc, usgs[name][2]);
file.close()
