#include "gausslegquad.h"

static double GLQabcissas[12][12] = {
/* 1*/{0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000},
/* 2*/{-.5773502692, 0.5773502692, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000},
/* 3*/{0.0000000000, -.7745966692, 0.7745966692, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000},
/* 4*/{-.3399810436, 0.3399810436, -.8611363116, 0.8611363116, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000},
/* 5*/{0.0000000000, -.5384693101, 0.5384693101, -.9061798459, 0.9061798459, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000},
/* 6*/{-.2386191861, 0.2386191861, -.6612093865, 0.6612093865, -.9324695142, 0.9324695142, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000},
/* 7*/{0.0000000000, -.4058451514, 0.4058451514, -.7415311856, 0.7415311856, -.9491079123, 0.9491079123, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000},
/* 8*/{-.1834346425, 0.1834346425, -.5255324099, 0.5255324099, -.7966664774, 0.7966664774, -.9602898565, 0.9602898565, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000},
/* 9*/{0.0000000000, -.3242534234, 0.3242534234, -.6133714327, 0.6133714327, -.8360311073, 0.8360311073, -.9681602395, 0.9681602395, 0.0000000000, 0.0000000000, 0.0000000000},
/*10*/{-.1488743390, 0.1488743390, -.4333953941, 0.4333953941, -.6794095683, 0.6794095683, -.8650633667, 0.8650633667, -.9739065285, 0.9739065285, 0.0000000000, 0.0000000000},
/*11*/{0.0000000000, -.2695431560, 0.2695431560, -.5190961292, 0.5190961292, -.7301520056, 0.7301520056, -.8870625998, 0.8870625998, -.9782286581, 0.9782286581, 0.0000000000},
/*12*/{-.1252334085, 0.1252334085, -.3678314990, 0.3678314990, -.5873179543, 0.5873179543, -.7699026742, 0.7699026742, -.9041172564, 0.9041172564, -.9815606342, 0.9815606342}};

static double GLQweightvals[12][12] = {
/* 1*/{2.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000},
/* 2*/{1.0000000000, 1.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000},
/* 3*/{0.8888888889, 0.5555555556, 0.5555555556, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000},
/* 4*/{0.6521451549, 0.6521451549, 0.3478548451, 0.3478548451, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000},
/* 5*/{0.5688888889, 0.4786286705, 0.4786286705, 0.2369268851, 0.2369268851, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000},
/* 6*/{0.4679139346, 0.4679139346, 0.3607615730, 0.3607615730, 0.1713244924, 0.1713244924, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000},
/* 7*/{0.4179591837, 0.3818300505, 0.3818300505, 0.2797053915, 0.2797053915, 0.1294849662, 0.1294849662, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000},
/* 8*/{0.3626837834, 0.3626837834, 0.3137066459, 0.3137066459, 0.2223810345, 0.2223810345, 0.1012286363, 0.1012286363, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000},
/* 9*/{0.3302393550, 0.3123470770, 0.3123470770, 0.2606106964, 0.2606106964, 0.1806481607, 0.1806481607, 0.0812743883, 0.0812743883, 0.0000000000, 0.0000000000, 0.0000000000},
/*10*/{0.2955242247, 0.2955242247, 0.2692667193, 0.2692667193, 0.2190863625, 0.2190863625, 0.1494513492, 0.1494513492, 0.0666713443, 0.0666713443, 0.0000000000, 0.0000000000},
/*11*/{0.2729250868, 0.2628045445, 0.2628045445, 0.2331937646, 0.2331937646, 0.1862902109, 0.1862902109, 0.1255803695, 0.1255803695, 0.0556685671, 0.0556685671, 0.0000000000},
/*12*/{0.2491470458, 0.2491470458, 0.2334925365, 0.2334925365, 0.2031674267, 0.2031674267, 0.1600783285, 0.1600783285, 0.1069393260, 0.1069393260, 0.0471753363, 0.0471753363}};


/* return an array of n places to compute Gauss-Legendre Quadrature
 *
 * returns pointer to static array - DO NOT FREE OR CHANGE!
 */
double *GLQinterval(int n)
{
  if(n<1 || n>12) { return((double *)0); }
  return(GLQabcissas[n-1]);
}

/* return an array of n weights to compute Gauss-Legendre Quadrature
 *
 * returns pointer to static array - DO NOT FREE OR CHANGE!
 */
double *GLQweights(int n)
{
  if(n<1 || n>12) { return((double *)0); }
  return(GLQweightvals[n-1]);
}
