#ifndef SPH_HARM_GRAV_CONSTANTS
#define SPH_HARM_GRAV_CONSTANTS

#define PI	 3.1415926535897
#define RAD2DEG	 5.72957795130823e+01
#define DEG2RAD  1.74532925199433e-02

/* convert row, col to linear index */
#define sub(r,c,nc)	((c)+((r)*(nc)))

/* constants for the WGS84 ellipsoid */
#define WGS84_a	6378137.0000	/* m, major axis */
#define WGS84_b 6356752.3412	/* m, minor axis */
#define WGS84_f 3.35281066474748e-03	/* 1/298.257223563 */
#define WGS84_R ((2*WGS84_a+WGS84_b)/3) /* mean radius of the Earth */
#define WGS84_e2 6.69437999014e-3 /* eccentricity squared */

#define BIGG	6.67428e-11 /* m^3.kg^-1.s^-2, Gravitation constant, from NIST, Feb 2010 */

#endif
