#
# Correct temperature readings of a meter and apply an update to the
# gravity values.  Designed to work with the raw timeseries coming in,
# before time series analysis!!!
import math

def fix(data, threshhold):
  # run through the data, correcting any readings with |temp| > thresh
  # back to short-window average of readings within thresh
  temps = []	# array of temps within threshhold
  avgT = []	# array of short-window average temps within threshhold
  for i in range(len(data)):
    if abs(data[i].temp) <= abs(threshhold):
      temps.append([data[i].temp, data[i].jul_day]);
  for i in range(len(temps)):
    start = i-5; end = i+5;
    if start < 0: start=0
    if end > len(temps)-1: end = len(temps)-1
    sum = 0;
    for j in range(start,end):
      sum += temps[j][0]
    avgT.append(sum/(end-start))
  for i in range(len(data)):
    if abs(data[i].temp) > abs(threshhold):
      # find index of good temp nearest data point
      index = 0
      dt = abs(data[i].jul_day - temps[index][1])
      for j in range(1,len(temps)):
        if abs(data[i].jul_day - temps[j][1]) < dt:
          dt = abs(data[i].jul_day - temps[j][1])
          index = j
      dT = data[i].temp - avgT[index]
      data[i].uncorrected_temp = [data[i].gravity, data[i].temp]
      data[i].gravity += data[i].temp*data[i].meterInfo.TempCo	# remove wrong temp compensation
      data[i].temp -= dT	# update temp
      data[i].gravity -= data[i].temp*data[i].meterInfo.TempCo # correct grav for new temp
  return 1
