# Tare editing code
# create a window with all the tare listings, and an editing window
# where time and values can be changed
# then write into tare dict

from Tkinter import *

import grav_util
from StatusWindow import *

# core of code for tare.py and tare edit section of reduce.py

class privateData:
  def __init__(self):
    self.tare = None
    self.keys = None
    self.index = 0
    self.monthVal = None
    self.dayVal = None
    self.yearVal = None
    self.hourVal = None
    self.minVal = None
    self.secVal = None
    self.tareVal = None

def apply_tares(data, tares):
  # data is reduced data as used in reduce.py
  # tares is tare db from reduce.py
  for i in data.keys():
    data[i].G = data[i].nodrift_gravity # reset G value
    for j in tares.keys():
      if j < data[i].time+data[i].start_time:
	data[i].G = data[i].G + tares[j] # update G value

def main(tares):
  global priv, edit_w, status
  # tares is pre-existing dict of tare data
  # dictionary is time:magnitude, time in JD

  priv = privateData()

  priv.tare = tares

  priv.keys = tares.keys()
  priv.keys.sort(grav_util.num_sort)

  priv.index = 0

  # create 2 windows, assume Tk already fired up
  edit_w = Toplevel()
  edit_w.title("Edit Tares")
  view_w = Toplevel()
  view_w.title("View Tares")

  # create a StatusWindow for the view window
  status = StatusWindow(view_w, 40, 20)
  status.show()

  # build the editing window
  time_F = Frame(edit_w, relief=FLAT)
  priv.monthVal = StringVar()
  priv.dayVal = StringVar()
  priv.yearVal = StringVar()
  priv.hourVal = StringVar()
  priv.minVal = StringVar()
  priv.secVal = StringVar()
  Entry(time_F, textvariable=priv.monthVal, width=2).grid(row=0, column=0, sticky=W)
  Label(time_F, text="/").grid(row=0, column=1, sticky=W)
  Entry(time_F, textvariable=priv.dayVal, width=2).grid(row=0, column=2, sticky=W)
  Label(time_F, text="/").grid(row=0, column=3, sticky=W)
  Entry(time_F, textvariable=priv.yearVal, width=4).grid(row=0, column=4, sticky=W)
  Entry(time_F, textvariable=priv.hourVal, width=2).grid(row=0, column=5, sticky=E)
  Label(time_F, text=":").grid(row=0, column=6, sticky=E)
  Entry(time_F, textvariable=priv.minVal, width=2).grid(row=0, column=7, sticky=E)
  Label(time_F, text=":").grid(row=0, column=8, sticky=E)
  Entry(time_F, textvariable=priv.secVal, width=2).grid(row=0, column=9, sticky=E)
  time_F.grid(columnspan=2)

  val_F = Frame(edit_w, relief=FLAT)
  priv.tareVal = StringVar()
  priv.tareVal.set("0.0")
  Label(val_F, text="Offset:").grid(sticky=W)
  Entry(val_F, textvariable=priv.tareVal, width=6).grid(row=0, column=1, sticky=W)
  Label(val_F, text="mGal").grid(row=0, column=2, sticky=W)
  val_F.grid(columnspan=2)

  Button(edit_w, text="<--", command=prev_cb).grid(row=2, column=0)
  Button(edit_w, text="-->", command=next_cb).grid(row=2, column=1)
  Button(edit_w, text="Quit", command=quit_cb).grid(row=3, column=0)
  Button(edit_w, text="Commit", command=commit_cb).grid(row=3, column=1)

  print_db()
  set_fields()

  # run
  edit_w.mainloop()
  edit_w.destroy()
  view_w.destroy()
  return priv.tare


def set_fields():
  global priv
  if not priv.tare:
    return

  if not priv.tare.has_key(priv.keys[priv.index]):
    return
  # convert JD to date strings
  (year, month, day, hour, minute, second) = grav_util.un_jday(priv.keys[priv.index])
  # set the fields
  priv.monthVal.set(str(month))
  priv.dayVal.set(str(day))
  priv.yearVal.set(str(year))
  priv.hourVal.set(str(hour))
  priv.minVal.set(str(minute))
  priv.secVal.set(str(second))
  priv.tareVal.set(str(priv.tare[priv.keys[priv.index]]))

def prev_cb(*event):
  global priv
  # reset fields to previous in keys
  if priv.index < 1:
    return
  priv.index = priv.index - 1
  set_fields()

def next_cb(*event):
  global priv
  if priv.index >= len(priv.keys)-1:
    return
  priv.index = priv.index + 1
  set_fields()

def quit_cb(*event):
  global edit_W
  edit_w.quit()

def print_db(*event):
  global priv, status

  status.clear()
  status.write("#___DATE___ __TIME__   TARE OFFSET\n")

  k = priv.tare.keys()
  k.sort(grav_util.num_sort)
  for i in k:
    dstr = grav_util.datestr(i)
    status.write("#%s   %10f\n"%(dstr, priv.tare[i]))
  status.update()

def commit_cb(*event):
  global priv
  # commit changes to database, refresh view window
  try:
    year = int(priv.yearVal.get())
    month = int(priv.monthVal.get())
    day = int(priv.dayVal.get())
    hour = int(priv.hourVal.get())
    minute = int(priv.minVal.get())
    second = int(priv.secVal.get())
    val = float(priv.tareVal.get())
  except:
    return

  jd = grav_util.calc_jday(year, month, day, hour, minute, second)

  priv.tare[jd] = val

  # update view
  print_db()

  # update keys and sort
  priv.keys = priv.tare.keys()
  priv.keys.sort(grav_util.num_sort)
