#
# Compute gravity correction for Bouguer slab to a spherical cap,
# using WGS84 ellipsoid and the equations from LaFehr (1991).
#

from math import *

# calculate the curvature correction to a Bouguer slab to turn slab
# into a spherical cap, given height of station above ellipsoid as
# h (m), latitude of station in degrees, and density as rho (kg/m^3)
def calc(h, latitude, rho):
  if h==0:
    return(0) # h==0 ==> no cap!
  WGS84_a = 6378137.0000	# m, major axis
  WGS84_b = 6356752.3412	# m, minor axis
  G = 6.67428e-11		# m^3.kg^-2.s^-2
  lat = radians(latitude)
  s2 = sin(lat)*sin(lat);
  c2 = cos(lat)*cos(lat);
  R0 = 1.0/sqrt( s2/(WGS84_b*WGS84_b) + c2/(WGS84_a*WGS84_a) );
  R = R0 + h;
  delta = R0/R
  eta = h/R
  alpha = 166735/R0; # angle of spherical cap at this latitude
  mu = 1/3*eta*eta - eta;
  d = 3*cos(alpha)*cos(alpha) - 2
  f = cos(alpha)
  k = sin(alpha)*sin(alpha)
  p = -6*cos(alpha)*cos(alpha)*sin(alpha/2) + 4*pow(sin(alpha/2), 3)
  m = -3*sin(alpha)*sin(alpha)*cos(alpha)
  n = 2*( sin(alpha/2) - sin(alpha/2)*sin(alpha/2) )
  t1 = d+f*delta+delta*delta;
  t2 = sqrt( pow(f-delta,2) + k );
  L =  t1*t2 + p
  L = L + m*log( n/(f-delta+t2) )
  L = L/3;
  CC = 2*pi*G*rho*(mu*h - L*R) # correction in m/s^2
  return(CC*1e5) # convert to mGal

