#!/usr/bin/python

# Convert from the output of reduce.py (a .out file) to the input
# format for USGS SWFO gravity programs terrain_correct and pfact

# usage: reduce2pfact.py input output
# can use 

import sys
import jd
from math import fabs

if len(sys.argv) < 3:
  sys.stderr.write("usage: %s input output\n"%sys.argv[0]);
  sys.stderr.write("if input or output are -, use stdin/stdout\n");
  sys.exit(1);

if sys.argv[1] == "-":
  infile = sys.stdin
else:
  infile = open(sys.argv[1], "rt")

if sys.argv[2] == "-":
  outfile = sys.stdout
else:
  outfile = open(sys.argv[2], "wt")

start = jd.str2jd("1899/12/31", "12:00:00")
for line in infile:
  line = line.strip()
  if not line: continue
  if line[0] == "#": continue
  fields = line.split(None);
  name = fields[0][0:8]	# cap at 8 characters
  declat = float(fields[7])
  lat = int(fabs(declat))
  latmin = (fabs(declat) - lat)*60.0
  if declat < 0: lat *= -1
  declon = float(fields[6])
  lon = int(fabs(declon))
  lonmin = (fabs(declon) - lon)*60.0
  if declon < 0: lon *= -1
  elev = float(fields[8])
  grav = float(fields[2])
  sigma = float(fields[3])
  iztc = 0.0
  ttc = 0.0
  date = jd.str2jd(fields[4], fields[5])
  dateoffset = date - start

  outfile.write("%-8s%4d%7.3f%6.3f%5d%7.3f%6.3f m%8.2f%5.2f%11.3f%6.3f%6.2f%7.2f%4.2f%11.4f\n"%(name,
    lat, latmin, 0.001, lon, lonmin, 0.001, elev, 0.001, grav, sigma, iztc, ttc, 0.10, dateoffset))

sys.exit(0);
