#!/usr/bin/python

# Convert from the output of reduce.py (a .out file) to a file for
# use in exploration analysis; specifically, drop date/time and
# produce a single unique value for each station NAME

# usage: reduce2expl.py input output [iztc_file]

import sys
import jd
from math import fabs

from grav_data import ExplorationStn

if len(sys.argv) < 3:
  sys.stderr.write("usage: %s input output [iztc_file]\n"%sys.argv[0]);
  sys.stderr.write("if input or output are -, use stdin/stdout\n");
  sys.stderr.write("iztc_file is optional; format is: name iztc in mGal\n");
  sys.exit(1);

if sys.argv[1] == "-":
  infile = sys.stdin
else:
  infile = open(sys.argv[1], "rt")

if sys.argv[2] == "-":
  outfile = sys.stdout
else:
  outfile = open(sys.argv[2], "wt")

iztcs = {}
if len(sys.argv)>3: # read inner zone tc file
  izfile = open(sys.argv[3], "rt")
  for line in izfile:
    line=line.strip()
    if not line: continue
    if line[0]=="#": continue
    fields=line.split()
    iztcs[fields[0]] = float(fields[1])
  izfile.close()

stns = {}
count = {}

for line in infile:
  line = line.strip()
  if not line: continue
  if line[0] == "#": continue
  fields = line.split(None);
  name = fields[0][0:25]	# cap at 25 characters
  lat = float(fields[7])
  lon = float(fields[6])
  elev = float(fields[8])
  grav = float(fields[2])
  sigma = float(fields[3])
  iztc = 0.0
  if name in iztcs:
    iztc = iztcs[name]
  ttc = 0.0

  if stns.has_key(name):
    if sigma > stns[name].sigma:
      stns[name].sigma = sigma;
      stns[name].gravity = grav;
  else:
    stns[name] = ExplorationStn();
    stns[name].station_id = name
    stns[name].lat = lat
    stns[name].lon = lon
    stns[name].elev = elev
    stns[name].gravity = grav
    stns[name].sigma = sigma
    stns[name].iztc = iztc;
    stns[name].tc = ttc;

outfile.write("# data prepared by reduce2expl.py from %s\n"%sys.argv[1]);
if len(iztcs)>0:
  outfile.write("# inner zone terrain correctiosn read from %s\n"%sys.argv[3]);
outfile.write("# repeated occupations in input file collapsed to entry with largest sigma!\n");
outfile.write("# STATION NAME              LONGITUDE    LATITUDE ELEVATION_m GRAVITY_mGal ERROR IZ_TERRC TERR_COR COMMENT\n")
for s in sorted(stns.keys()):
  outfile.write("%-25s %11.6f %11.6f %11.3f %12.3f %5.3f %8.3f %8.3f\n"%(stns[s].station_id,
    stns[s].lon, stns[s].lat, stns[s].elev, stns[s].gravity, stns[s].sigma, stns[s].iztc, stns[s].tc))

sys.exit(0);
