# quadrature routines for Python

from math import *

def sinc_ftest(t, v1, v2):
  # specialized sinc quadrature routine to compute integral
  # for the F Test
  # see written notes for derivation

  # choose N for desired error bound
  N = 20

  # compute h, given d, a, N
  d = pi/2
  a = .5

  h = sqrt((pi*d)/(a*N))

  err = sqrt(N)*exp(-1.0*sqrt(pi*d*a*N))

  # precompute some constants, for clarity and speed
  E1 = (v1/2.0) - 1.0
  E2 = -(v1+v2)/2.0

  # do the loop
  I = 0.0
  for k in range(-N, N+1):
#    Zk = t*exp(k*h) / (1+exp(k*h))
#    P = (t - Zk) / t
#    I = I + ( (Zk**E1) * ((v2+v1*Zk)**E2) )*P
    Zk = exp(k*h) / (1+exp(k*h))
    I = I + ( (Zk**E1) * ((1 + (v1*t*Zk)/v2)**E2) * (1-Zk) )

  I = I*(t**(v1/2.0))

  return (I, err)

def trap(t, v1, v2):
  # trapezoidal integration

  N = 500

  h = float(t)/N

  E1 = (v1/2.0) - 1
  E2 = -(v1+v2)/2.0

  I = 0.0
  for k in range(N):
    # 1/2*h*(f1+f2)
    x1 = k*h
    x2 = x1+h

    f1 = x1**E1 * (v2 + v1*x1)**E2
    f2 = x2**E1 * (v2 + v2*x2)**E2
    I = I + 0.5*h*(f1+f2)

  return I

