# test the polyfit functions

# generate some synthetic data

from random import normalvariate
import polyfit

# data[].nodrift_gravity
# data[].sigma
# data[].time

class Point:
  def __init__(self, g, s, t):
    self.nodrift_gravity = g
    self.sigma = s
    self.time = t


# drift function coefficients
# 3 paramaters ==> cubic
A = [1, 2, 3]

N = 3

# generate synthetic data
# need repeats database
data={}
repeats={0:[7,14], 1:[8,], 2:[9,], 3:[10,], 4:[11,], 5:[12,], 6:[13,]}
G = [1100, 1200, 1300, 1400, 1500, 1600, 1700, 1100, 1200, 1300, 1400, 1500, 1600, 1700, 1100]
dG = .020
S = [.01, .01, .01, .01, .01, .01, .010, .01, .01, .01, .01, .01, .01, .01, .01]
dS = .000
T = [.05, .1, .15, .2, .25, .3, .35, .40, .45, .50, .55, .60, .65, .70, .75]
dT = .02

# randomize the data
print "Starting data set; dG, dS, and dT are multiplied by 1000"
print " I : _____G______ ____dG___ __F*1000_  _____S______ ____dS__ _____T______ ___dT__"
#for i in repeats.keys():
#  pG = normalvariate(0.0, dG)
#  G[i] = G[i] + pG
#  pT = normalvariate(0.0, dT)
#  T[i] = T[i] + pT
#  pS = normalvariate(0.0, dS)
#  S[i] = S[i] + pS
#  print "%3d: %18f %18f %18f"%(i, G[i], S[i], T[i])
#  f = 0.0
#  for j in range(N):
#    f = f + (A[j]*T[i]**(j+1))
#  G[i] = G[i] + f
#  data[i] = Point(G[i], S[i], T[i])
#  data[i].G = G[i] - f
#  for k in range(len(repeats[i])):
#    n = repeats[i][k]
#    T[n] = T[n] + pT
#    G[n] = G[n] + pG
#    f = 0.0
#    for j in range(N):
#      f = f + (A[j]*T[n]**(j+1))
#    G[n] = G[n] + f
#    S[n] = S[n] + pS
#    data[n] = Point(G[n], S[n], T[n])
#    data[n].G = G[n] - f
#    print "%3d: %18f %18f %18f"%(n, G[n], S[n], T[n])
for i in range(len(G)):
  g = G[i]; t = T[i]; s = S[i]
  G[i] = G[i] + normalvariate(0.0, dG)
  T[i] = T[i] + normalvariate(0.0, dT)
  S[i] = S[i] + normalvariate(0.0, dS)
  f = 0.0
  for j in range(N):
    f = f + (A[j]*T[i]**(j+1))
  G[i] = G[i] + f
  data[i] = Point(G[i], S[i], T[i])
  data[i].G = G[i] - f
  print "%3d: %12f %9.3f %9.3f %12f %9.3f %12f %9.3f"%(i, G[i],(G[i]-g)*1000,
    f*1000, S[i], (S[i]-s)*1000, T[i], (T[i]-t)*1000.0)

# run inversion
a = polyfit.correction(data, repeats, {})

print "Actual coeff.: %s"%A
print "Polyfit result: %s"%a

# recompute undrifted gravity
print " I : __G_before_drift__ __G_after_polyfit_ __Difference*1000_" 
k = data.keys()
k.sort()
for i in k:
  f = 0.0
  for j in range(len(a)):
    f = f + (a[j]*data[i].time**(j+1))
  data[i].Gp = data[i].nodrift_gravity - f
  print "%3s: %18f %18f %18f"%(i, data[i].G, data[i].Gp, (data[i].Gp - data[i].G)*1000.0)

