import string
from parmclass import *
from fileop import *
from grav_util import num_sort

S = {}

def read_parms(filename):
  global S
  parms = []
  P = get_sta_parms(filename)
  R = get_sta_repeats(filename)
  N = get_sta_names(filename)
  S = get_sta_skips(filename)
  K = P.keys()
  K.sort(num_sort)
  for i in K:
    incoming = StationParameters()
    incoming.sid = i
    incoming.lat = float(P[i].lat)
    incoming.lon = float(P[i].lon)
    incoming.Z = float(P[i].elevation)
    incoming.dZ = float(P[i].Z)
    parms.append(incoming)
    if R.has_key(i):
      parms[-1].repeat = R[i]
    if N.has_key(i):
      parms[-1].name = N[i]
  return parms
    

def write_parms(parms, filename, comment, timestamp):
  global S
  file = open(filename, "wt")

  file.write("# %s\n" % comment);
  file.write("# %s\n" % timestamp);
  # write station parameters
  file.write("[PARAMETERS]\n");
  for i in range(len(parms)):
    if parms[i].sid != "NONE":
      file.write("%6s %12.7f %12.7f %10.3f %5.1f\n"%(parms[i].sid, parms[i].lat, parms[i].lon, parms[i].Z, parms[i].dZ))

  # write station repeats
  file.write("\n[REPEATS]\n");
  for i in range(len(parms)):
    if parms[i].sid != "NONE":
      for j in range(len(parms[i].repeat)):
	file.write("%6s %6s\n"%(parms[i].sid, parms[i].repeat[j]))

  # write station names
  file.write("\n[NAMES]\n")
  for i in range(len(parms)):
    if parms[i].sid != "NONE":
      file.write("%6s %s\n"%(parms[i].sid, parms[i].name))

  # write skipped stations
  file.write("\n[SKIPS]\n")
  K = S.keys()
  K.sort(num_sort)
  for i in K:
   file.write("%6s\n"%i)

  file.close()
