# Class for station parameters
import Tkinter

class StationParameters:
  def __init__(self):
    self.sid = None
    self.name = None
    self.lat = None
    self.lon = None
    self.Z = None
    self.dZ = None
    self.repeat = []

class EntryWindow:
  def __init__(self, title):
    self.win = Tkinter.Toplevel()
    self.win.title(title)

class ViewWindow:
  def __init__(self, title):
    self.win = Tkinter.Toplevel()
    self.win.title(title)

class TextEntry:
  def __init__(self, master, label):
    self.box = Tkinter.Frame(master, relief="flat")
    Tkinter.Label(self.box, text=label).grid(sticky="W", column=0, row=0)
    self.field = Tkinter.Entry(self.box)
    self.field.grid(sticky="W", column=1, row=0)

  def get(self):
    return self.field.get()

  def set(self, value):
    # first delete contents of entry box
    # then fill
    self.field.delete(0,"end")
    self.field.insert("end", str(value))
