# gravity data classes module
# import as from grav_data.py import *

class GravityReading:
  # This object is for the raw reading
  # don't have to declare anything here, but it makes
  # consistency MUCH easier to have it all written down somewhere
  def __init__(self):
    self.station_id = "none"
    self.gravity = -1.0
    self.sigma = 0.001		# CG-3 only
    self.tilt_x = -9999
    self.tilt_y = -9999
    self.temp = -9.9
    self.etc = -999.9
    self.duration = -1		# CG-3 only
    self.time_str = "25:61:61"
    self.jul_day = -1.0
    self.tiltCorrect = "N"
    self.GMT_Diff = 25.0
    self.rejects = -1		# CG-3 only
    self.volts = 0.0		# Aliod only; batt voltage
    self.meterInfo = CG3MeterInfo()	# meter-specific info that
    					# doesn't change with reading

class CG3MeterInfo:
  # Object to hold CG3-specific data, mostly set from
  # CG-3M data file headers
  def __init__(self):
    self.ROM_Version = "none"
    self.Mode = "none"
    self.ROM_Release = "none"
    self.Cycle_time = -1.0
    self.Serial_number = -1
    self.Line = -1
    self.Grid = -1
    self.Job = -1
    self.Operator = -1
    self.GRef = -1.0
    self.TxCo = -999.9
    self.TyCo = -999.9
    self.GCal1 = -1.0
    self.GCal2 = -1.0
    self.Lat = -1.0
    self.Lon = -1.0
    self.TempCo = -999.9
    self.CalAfter = -1
    self.DriftCo = 0.0
    self.DriftStart = 0.0

class AliodMeterInfo:
  # Object to hold meter-specific constants, set from
  # Aliod meter info file
  def __init__(self):
    self.calibration = {}	# Dictionary of counter=>mGal
    self.x_sens = 0.0		# cross level to mGal constant
    self.y_sens = 0.0		# long level to mGal constant
    self.set_temp = 0.0		# temperature set point of this meter
    self.GMT_default = 0.0	# Default GMT offset; override w/cmd file


class GravityValue:
  # This class is where we do all the reduction
  def __init__(self):
    # once again, we need not define anything here, but it helps for
    # later consistency to define the necessary fields here
    self.station_id = "none"
    self.lat = -99.0
    self.lon = -361.0
    self.GMT_Diff = 25.0
    self.time = -99999.9	# averaged time, in days
    self.jul_day = -99999.9	# averaged time; should be = self.time
    self.raw_gravity = -1.0	# averaged gravity reading
    self.raw_sigma = -1.0	# averaged gravity reading std dev
    self.etc_correction = 0.0
    self.atmospheric_correction = 0.0
    self.dz_correction = 0.0
    self.drift_correction = 0.0	# drift correction applied to reading
    self.nodrift_gravity = -1.0	# grav reading corrected except for drift
    self.G = -1.0		# intermediate results
    self.gravity = -1.0		# reduced gravity reading
    self.sigma = -1.0		# reduced gravity reading std dev
    self.deltag = -9999999.9	# reduced gravity relative to base

class Incoming:
  def __init__(self):
      self.exist = "yes"

class Station:
  def __init__(self, name, g, s, date):
    self.name = name
    self.gravity = g
    self.sigma = s
    self.time = date


class ExplorationStn:	# objects for exploration-type processing
  def __init__(self):	# fill from reduce.py output files....
    self.station_id = "none"	# stn id string
    self.lat = -99.0		# dec degrees!
    self.lon = -361.0
    self.elev = -9999		# elevation, in m ASL
    self.time = -99999.9	# time, in fractional Julian days
    self.gravity = -1.0		# gravity reading, mGal
    self.sigma = -1.0		# gravity reading std err*2
    self.iztc = 0;		# inner zone terrain correction
    self.ttc = 0;		# total tc for this stn
    self.rho = []		# CBGA reduction densities
    self.cbga = []		# CBGA for this stn, for each density
