# Fit exponential to a station
from math import *
from random import *
from Numeric import *
import marquardt
import time

def ymod(x, a):
  z = a[0] + a[1]*exp(-1*a[2]*x)
  return z

def dy(x, a):
  # compute dy/da[] for each a, and store in vector
  z = [0.0,0.0, 0.0]

  z[0] = 1.0
  z[1] = exp(-1.0*a[2]*x)
  z[2] = -1.0*a[1]*x*exp(-1.0*a[2]*x)
  return z

def station_fit(t, y, s):
  # fit y(t) to exponential, and return coefficients of fit

  # we fit to 2 parameters, a[0], a[1]
  ia = [1,1,1]

  # create initial vector a
  a = [4000,16,.9]

  print "Running inversion with eps=1e-5"

  return marquardt.fit(t, y, s, a, ia, ymod, dy, 1e-5)


# main loop

# set actual values
A = [4100, 3.0, .333]
N = 20
err = 0.3

# compute synthetic data
t = range(N)
y = t[:]
s = t[:]

for i in range(len(t)):
  t[i] = float(t[i]/2.0)
  y[i] = ymod(t[i], A)+normalvariate(0.0, err)
  s[i] = normalvariate(0.0, err)

# read real data
file = open("data2", "rt")
lines = file.readlines()
file.close()
tr = []
yr = []
sr = []
for line in lines:
  (T, Y, S) = string.split(line)
  tr.append(float(T))
  sr.append(float(S))
  yr.append(float(Y))

# Do the inversions

print "**************"
print "Synthetic data"
print "**************"

# invert data for a fit
start = time.clock()
(a, cov, chisq, ni) = station_fit(t, y, s)
end = time.clock()

# print the output
print "  Synthetic Parameters"
print A
print "  Staring parameters: [6, 0.9]"
print "  Inversion converged after %d iterations"%ni
print "  Inversion results"
print a
print "  Covariance matrix"
print cov
print "  Final chi-squared: %g"%chisq
print "  Inversion took %g seconds"%(end-start)

print "*****************"
print "Real gravity data"
print "*****************"

# invert data for a fit
start = time.clock()
(a, cov, chisq, ni) = station_fit(tr, yr, sr)
end = time.clock()

# print the output
print "  Inversion converged after %d iterations"%ni
print "  Inversion results"
print a
print "  Covariance matrix"
print cov
print "  Final chi-squared: %g"%chisq
print "  Inversion took %g seconds"%(end-start)
