#!/usr/bin/python
# create a parameter file from a listing of station id->names
# and a file with positions for each station

import sys, string, time
from Tkinter import *
import tkFileDialog, tkMessageBox

from parmio import *
from parmclass import *
from grav_util import num_sort

## FIXME - add tkinter interface
root = Tk()
root.title("Build a Parameter File")

nameFile = tkFileDialog.askopenfilename(parent=root,
  title="ID-name Map File", initialdir=".", filetypes=(("All files", "*"),) )
if not nameFile:
  print "Must provide a name-ID map file!"
  sys.exit(0)

posFile = tkFileDialog.askopenfilename(parent=root,
  title="Station Coordinate File", initialdir=".",
  filetypes=(("Coordinate files", "*.coord"), ("All files", "*")) )
if not posFile:
  print "Must provide a coordinate file!"
  sys.exit(0)

skipFile = tkFileDialog.askopenfilename(parent=root,
  title="Station Skip File", initialdir=".",
  filetypes=(("All files", "*"),) )
if not skipFile:
  skipFile = None

outputFile = tkFileDialog.asksaveasfilename(parent=root,
  title="Output Parameter File", initialdir=".",
  filetypes=(("Parameter files", "*.par"), ("All files", "*")) )
if not outputFile:
  print "Must provide an output file!"
  sys.exit(0)

# get the id->name mapping
file = open(nameFile, "rt")
lines = file.readlines()
file.close()

ids = {}
names = {}
for line in lines:
  line = string.strip(line)
  if not line:
    continue
  fields = string.split(line, None, 1)
  if not names.has_key(fields[1]):
    names[fields[1]] = []
  names[fields[1]].append(fields[0])
  ids[fields[0]] = fields[1]

# get the station positions
file = open(posFile, "rt")
lines = file.readlines()
file.close()

parms = {}
for i in lines:
  line = string.strip(i)
  if not line:
    # blank line
    continue
  if line[0] == "#":
    # comment
    continue
  fields = string.split(line)
  # format is name,lat,lon,Z [,dZ]
  parms[fields[0]] = StationParameters()
  parms[fields[0]].name = fields[0]
  parms[fields[0]].lat = float(fields[1])
  parms[fields[0]].lon = float(fields[2])
  parms[fields[0]].Z = float(fields[3])
  if len(fields) > 4:
    parms[fields[0]].dZ = float(fields[4])
  else:
    parms[fields[0]].dZ = 0.0

# now set repeats for each station name
repeats = {}
for i in names.keys():
  repeats[names[i][0]] = names[i][1:]

# get the stations to skip
# format is name/id on a line
# first look for name match, if none then assume station id
if skipFile:
  file = open(skipFile, "rt")
  lines = file.readlines()
  file.close()
  for line in lines:
    line = string.strip(line)
    if not line:
      continue
    if not names.has_key(line):
      S[line] = 1
    else:
      for i in range(len(names[line])):
	S[names[line][i]] = 1

# create the StationParameter array with an entry for every station
K = ids.keys()
K.sort(num_sort)
P = []
for i in K:
  if not parms.has_key(ids[i]):
    if not S.has_key(ids[i]) and not S.has_key(i):
      msg = "No position can be found in the coordinate file %s for station ID %s ('%s').  Please add the relevant coordinates to the coordinate file and rerun."%(posFile, i, ids[i]) 
      tkMessageBox.showerror("Position for %s"%i, msg)
      print "****"
      print "** ERROR - no position data for station %s ('%s')"%(i, ids[i])
      print "****"
      sys.exit(0)
  else:
    P.append(StationParameters())
    P[-1].sid = i
    P[-1].name = ids[i]
    P[-1].lat = parms[ids[i]].lat
    P[-1].lon = parms[ids[i]].lon
    P[-1].Z = parms[ids[i]].Z
    P[-1].dZ = parms[ids[i]].dZ
    if repeats.has_key(i):
      P[-1].repeat = repeats[i]


# write to output file
comment = "Generated by %s\n# files: %s\n# \t %s\n# \t %s"%(sys.argv[0], nameFile, posFile, skipFile)
timestamp = time.ctime(time.time())
write_parms(P, outputFile, comment, timestamp)

tkMessageBox.showinfo("Parameter File Done", "Parameter file %s written based on input files."%outputFile)
