#!/usr/bin/python
#
# Create file of lat, lon, Z, dZ for use in make_parm_file.py
#
# Uses a reference file with lat, lon, Z and a campaign file to compute
# dZ.
#
import sys, string;

class Position:
  def __init__(self, lat, lon, z, dz):
    self.lat = float(lat);
    self.lon = float(lon);
    self.ele = float(z);
    self.dz = float(dz);

def usage():
  print "usage: %s <reference file> <position file>"%(sys.argv[0]);
  print "where the 'reference file' has station lat/lon/elevation info"
  print "for the baseline.  The 'position file' has the station"
  print "lat/lon/elevation info for the current survey."
  print
  print "The result is sent to stdout, in a format suitable for use in"
  print "make_parm_file.py"
  print
  print "The reference file should be in the following format:"
  print "  NAME LAT LON Z"
  print "The position file should be in the following format:"
  print "  NAME   X   Y Z"
  print "[the X and Y entries are not used unless the NAME is not found"
  print " in the reference file.]"

def main():
  # check cmd-line args
  if len(sys.argv) < 3:
    usage()
    sys.exit(1);

  refFile = sys.argv[1];
  posFile = sys.argv[2];

  # read reference file, build dictionary
  rpos={};
  file=open(refFile, "rt");
  lines=file.readlines();
  file.close();
  for line in lines:
    line = string.strip(line);
    if not line: continue
    if line[0]=="#": continue;
    F=string.split(line);
    rpos[F[0]] = Position(F[1], F[2], F[3], 0);

  # read position file, compute station dz
  file = open(posFile, "rt");
  lines = file.readlines();
  file.close();
  for line in lines:
    line = string.strip(line);
    if not line: continue;
    if line[0] == "#": continue;
    F = string.split(line);
    if rpos.has_key(F[0]):
      rpos[F[0]] = Position(rpos[F[0]].lat, rpos[F[0]].lon,
	rpos[F[0]].ele, (float(F[3])-rpos[F[0]].ele)*100.0)
    else:
      rpos[F[0]] = Position(F[1], F[2], F[3], 0);
  # print the file
  for k in rpos.keys():
    print "%20s %12.6f %12.6f %12.6f %12.6f"%(k, rpos[k].lat,
      rpos[k].lon, rpos[k].ele, rpos[k].dz)
# done


main();
