# routines to log information to screen and file
from sys import stdout

class Logger:
  def __init__(self, name, append='n', window=None):
    mode = "wt"
    if append == 'y':
      mode = "at"
    self.__win_widget = window
    try:
      self.__logfile = open(name, mode)
    except:
      self.__logfile = stdout
      self.__logfile.write("CANNOT OPEN %s FOR MODE %s!\n"%(name, mode))

  def __del__(self):
    self.__logfile.close()

  def win(self, msg):
    self.__logfile.write(msg);
    if self.__win_widget != None:
      self.__win_widget.insert("end", msg);
      self.__win_widget.update();

  def scrn(self, msg):
    self.__logfile.write(msg);
    stdout.write(msg);
    stdout.flush();
