# GUI Utility functions for gravity package
from Tkinter import *
import string
from StatusWindow import *
import grav_util

class getCorrections:
  def __init__(self):
    # create a dialog, and wait for it to be clicked
    # return dictionary with mappings of field<->values
    self.options = {}
    self.option_vars = {}

    # get a new window
    self.window = Toplevel()
    self.window.title("Option Dialog")
    self.top = Frame(self.window);
    #self.top.grid_propagate(0);
    self.top.columnconfigure(0, weight=1)
    self.top.columnconfigure(1, weight=1)
    self.top.grid()

    Label(self.top, text="Reduction Options - checked is yes", font=("Helvetica", 16, "italic")).grid(columnspan=2, sticky=E+W)
    self.__rows = 1

    # data plot
    plotFrame = self.newFrame("Plot data time-series")
    self.createCheckBox(plotFrame, "raw_view", "Plot uncorrected raw data", 0)
    self.createCheckBox(plotFrame, "processed_view", "Plot corrected time-series data", 0)

    # pre-average corrections
    timeFrame = self.newFrame("Correct Raw Readings")
    self.createCheckBox(timeFrame, "longman", "Remove meter-applied Earth Tide correction?", 1)
    self.createCheckBox(timeFrame, "drift", "Remove meter-applied linear drift?", 0)
    self.createCheckBox(timeFrame, "tamura", "Apply Tamura ETC w/parameter file lat/lon?", 1)
    self.createCheckBox(timeFrame, "atmosphere", "Correct to fixed atmospheric pressure?", 0)
    self.createEntryBox(timeFrame, "base_pressure", " ---Base Atmospheric Pressure (mbar)", 0)
    self.createEntryBox(timeFrame, "gmt_offset", "Force ALL(!) GMT offsets to: (hrs E of GMT)", 0)
    self.createCheckBox(timeFrame, "tilt_corr", "Correct for meter tilt (Aliod ONLY!)?", 0)

    # Quality control of timeseries data, before averaging/extrapolation
    qaFrame = self.newFrame("Time-series Quality Assurance")
    self.createCheckBox(qaFrame, "temp_correct", "Correct temperatures outside threshhold to running average?", 0)
    self.createEntryBox(qaFrame, "temp_threshhold", " ---Temperature threshhold for correction (mK)", 0)
    self.createCheckBox(qaFrame, "temp_remove", "Remove raw data with temperatures outside threshhold?", 0)
    self.createEntryBox(qaFrame, "temp_threshhold_drop", " ---Temperature threshhold for removal (mK)", 0)
    self.createEntryBox(qaFrame, "sigma_threshhold", "Reading s.d. warning threshhold (mGal)", "0.050")
    self.createEntryBox(qaFrame, "slope_threshhold", "Occupation time-series detrend threshhold (uGal/hr)", "97.2")

    # Averaging or extrapolation, and parameters
    seriesFrame = self.newFrame("Time-series Processing")
    self.createCheckBox(seriesFrame, "thiele", "Use Thiele extrapolation instead of weighted averages?", 0)
    self.createCheckBox(seriesFrame, "grav_samples", "Time-series data are samples, not averages?", 0)
    self.createEntryBox(seriesFrame, "thiele_filt_radius", "Sample decimation filter radius, in data points", "30")
    self.createEntryBox(seriesFrame, "thiele_tolerance", "Thiele extrapolation equality tolerance", "1e-07")
    self.createEntryBox(seriesFrame, "skip", "Skip how many minutes at beginning of time-series\nwhen using weighted averages?", "3.0")
    self.createEntryBox(seriesFrame, "max_recs", "Maximum # of readings for weighted averages? (-1 to use all)", "-1")

    # post-average corrections
    stationFrame = self.newFrame("Station Occupation Corrections")
    self.createCheckBox(stationFrame, "dz", "Correct for elevation change listed in parameter file?", 0)
    self.createCheckBox(stationFrame, "instrument_drift", "Non-linear instrument drift corrections?", 1)
    self.createCheckBox(stationFrame, "weighted_drift", "Use weighted fit for drift functions?", 1)
    self.createEntryBox(stationFrame, "start_order", " ---Minimum order for polynomial drift functions", "0")
    self.createEntryBox(stationFrame, "order", " ---Maximum order for polynomial drift functions", "6")

    # gravity reference
    # two choices - absolute and station id
    refFrame = self.newFrame("Reference Gravity")
    self.createRadioButtons(refFrame, "ref_type", "Reference station gravity values to", ("a fixed value (in mGal)", "a station ID (enter below)", "an abs. gravity station"), 2)
    self.createEntryBox(refFrame, "ref_val", "Reference gravity", 0, 12)
    self.createEntryBox(refFrame, "ref_id", "Reference station ID", 0, 12)

    # layout all the frames of options
    plotFrame.grid(column=0, row=1, sticky=N+E+W)
    timeFrame.grid(column=0, row=2, sticky=E+W)
    stationFrame.grid(column=0, row=3, sticky=E+W)
    seriesFrame.grid(column=1, row=1, sticky=E+W)
    qaFrame.grid(column=1, row=2, sticky=E+W)
    refFrame.grid(column=1, row=3, sticky=E+W)

    # bottom buttons
    BFrame = self.newFrame("")
    BFrame.columnconfigure(1, weight=1)
    Button(BFrame, text="GO!", command=self.ok).grid(column=0, row=0)
    Button(BFrame, text="Quit", command=self.cancel).grid(column=1, row=0)
    BFrame.grid(columnspan=2,sticky=E+W)

  def newFrame(self, title):
    self.__rows = 1
    frame = Frame(self.top, relief=GROOVE, borderwidth=2);
    #frame.grid_propagate(0);
    frame.columnconfigure(0, weight=1)
    # add a title
    if title:
      self.createTitle(frame, title)
    return frame

  def createTitle(self, master, title):
    titleF = Frame(master, borderwidth=2, relief=RAISED)
    Label(titleF, text=title, font=("Helvetica", 14, "bold")).grid(columnspan=2,sticky=E+W)
    titleF.grid(sticky=EW,columnspan=2, row=self.__rows)
    self.__rows = self.__rows + 1

  def createCheckBox(self, master, option_name, option_prompt, default):
    # create vars for checkbox
    self.option_vars[option_name] = IntVar()
    Label(master, text=option_prompt).grid(column=0, row=self.__rows, sticky=W)
    b = Checkbutton(master, variable=self.option_vars[option_name])
    b.grid(column=1, row=self.__rows, sticky=E)
    if default:
      b.select()
    self.__rows += 1

  def createEntryBox(self, master, option_name, option_prompt, default, w=5):
    # create vars for entry box
    self.option_vars[option_name] = StringVar()
    if default:
      self.option_vars[option_name].set(default)
    Label(master, text=option_prompt).grid(sticky=W, column=0, row=self.__rows)
    Entry(master, textvariable=self.option_vars[option_name], width=w).grid(sticky=E, column=1, row=self.__rows)
    self.__rows += 1

  def createRadioButtons(self, master, option_name, option_prompt, value_prompts, default):
    self.option_vars[option_name] = IntVar()
    if default:
      self.option_vars[option_name].set(default)
    Label(master, text=option_prompt).grid(sticky=W, column=0, row=self.__rows)
    for i in range(len(value_prompts)):
      Radiobutton(master, variable=self.option_vars[option_name], text=value_prompts[i], value=i+1).grid(column=1, row=self.__rows, sticky=E)
      self.__rows += 1

  def run(self):
    self.top.update()
    self.top.wait_window(self.top)
    if self.option_vars:
      for i in self.option_vars.keys():
	# fill options dict with values
	self.options[i] = self.option_vars[i].get()

      # reformat some options to numbers, etc.
      try:
	self.options["xe"] = float(self.options["xe"])
      except:
	self.options["xe"] = 0.0
      try:
	self.options["ye"] = float(self.options["ye"])
      except:
	self.options["ye"] = 0.0
      try:
	self.options["order"] = int(float(self.options["order"]))
      except:
	self.options["order"] = 0
      try:
        self.options["thiele_filt_radius"] = int(self.options["thiele_filt_radius"])
      except:
        self.options["thiele_filt_radius"] = 0
      try:
	self.options["skip"] = float(self.options["skip"])
      except:
	self.options["skip"] = 0.0
      try:
	self.options["base_pressure"] = float(self.options["base_pressure"])
      except:
	self.options["base_pressure"] = 0.0
      try:
	self.options["sigma_threshhold"] = float(self.options["sigma_threshhold"])
      except:
	self.options["sigma_threshhold"] = 0.0
      try:
	self.options["slope_threshhold"] = float(self.options["slope_threshhold"])
      except:
	self.options["slope_threshhold"] = 0.0
      # convert slope_threshhold from uGal/hr to mGal/sec
      self.options["slope_threshhold"] = self.options["slope_threshhold"]/(1000*3600)
      try:
	self.options["gmt_offset"] = float(self.options["gmt_offset"])
      except:
	self.options["gmt_offset"] = None

      return self.options
    else:
      return None

  def ok(self):
    self.window.destroy()

  def cancel(self):
    self.option_vars = {}
    self.window.destroy()


class parameterWindow:
  def __init__(self, parms, names, repeats, height=24, width=80):
    self.__data = parms
    self.__name = names
    self.__repeat = repeats
    self.__win = Toplevel()
    self.__win.title("Station Parameters")

    self.__quit_b = Button(self.__win, text="Close Viewer", command=self.__quit)
    self.__quit_b.grid()

    self.__text = StatusWindow(self.__win, width, height)
    self.__text.show()

    self.__win.update()

  def __quit(self, *event):
    self.__win.destroy()

  def num_sort(self, a, b):
    return grav_util.num_sort(a, b)


  def refresh(self, *event):
    self.__text.clear()
    # column headings
    self.__text.insert(END, "  ID  |    STATION NAME    |REPEAT|  LATITUDE  | LONGITUDE  | ELEVATION|  dZ \n")
    # loop over database
    keys = self.__data.keys()
    # sort numerically!
    keys.sort(self.num_sort)
    for i in keys:
      # print parameters
      self.__text.insert(END, "%6s|%-20s|"%(i, self.__name[i]))
      if not self.__repeat.has_key(i):
	self.__text.insert(END, " None ")
      else:
	self.__text.insert(END, "%6s" % self.__repeat[i][0])

      self.__text.insert(END, "|%12.7f|%12.7f|%10.3f|%5.1f\n" % (self.__data[i].lat,
	self.__data[i].lon, self.__data[i].elevation, self.__data[i].Z))

      if self.__repeat.has_key(i):
	for j in range(1,len(self.__repeat[i])):
	  self.__text.insert(END,
	    "......|....................|%6s|............|............|..........|\n"
	    %(self.__repeat[i][j],))
    self.__text.update()


def parameterView(parms, names, repeats):
  view = parameterWindow(parms, names, repeats)
  view.refresh()


