# gamma.py - compute the gamma function relatively quickly

# algorithm taken from "Numerical Recipes in C", 2nd Ed.
# Translated to Python

import math

def gammln(xx):
  # coefficients
  cof = (76.18009172947146, -86.50532032941677, 24.01409824083091,
  -1.231739572450155, 0.1208650973866179e-2, -0.5395239384953e-5)

  y = float(xx); x = float(xx)
  tmp = x + 5.5
  tmp = tmp - (x+0.5)*math.log(tmp)
  ser = 1.000000000190015
  for j in range(len(cof)):
    y = y+1
    ser = ser + cof[j]/y
  return -tmp+math.log(2.5066282746310005*ser/x)

def gamma(xx):
  return math.exp(gammln(xx))

