# quadrature routines for Python

from math import *

def sinc_ftest(t, v1, v2):
  # specialized sinc quadrature routine to compute integral
  # for the F Test
  # see written notes for derivation

  # choose N for desired error bound
  N = 20

  # compute h, given d, a, N
  d = pi/2
  a = .5

  h = sqrt((pi*d)/(a*N))

  err = sqrt(N)*exp(-1.0*sqrt(pi*d*a*N))

  # precompute some constants, for clarity and speed
  E1 = (v1/2.0) - 1.0
  E2 = -(v1+v2)/2.0

  # do the loop
  I = 0.0
  for k in range(-N, N+1):
#    Zk = t*exp(k*h) / (1+exp(k*h))
#    P = (t - Zk) / t
#    I = I + ( (Zk**E1) * ((v2+v1*Zk)**E2) )*P
    Zk = exp(k*h) / (1+exp(k*h))
    I = I + ( (Zk**E1) * ((1 + (v1*t*Zk)/v2)**E2) * (1-Zk) )

  I = I*(t**(v1/2.0))

  return (I, err)

def trap(t, v1, v2):
  # trapezoidal integration

  N = 500

  h = float(t)/N

  E1 = (v1/2.0) - 1
  E2 = -(v1+v2)/2.0

  I = 0.0
  for k in range(N):
    # 1/2*h*(f1+f2)
    x1 = k*h
    x2 = x1+h

    f1 = x1**E1 * (v2 + v1*x1)**E2
    f2 = x2**E1 * (v2 + v2*x2)**E2
    I = I + 0.5*h*(f1+f2)

  return I


# Adaptive Quadrature with Simpson's Rule
# converted from FORTRAN
# original Fortran from:
#     NUMERICAL METHODS: FORTRAN Programs, (c) John H. Mathews 1994
#     To accompany the text:
#     NUMERICAL METHODS for Mathematics, Science and Engineering, 2nd Ed, 1992
#     Prentice Hall, Englewood Cliffs, New Jersey, 07632, U.S.A.
#     This free software is complements of the author.
#
#     Algorithm 7.5 (Adaptive Quadrature Using Simpson's Rule).
#     Section 7.4, Adaptive Quadrature, Page 389
#
#def asimp(f, a, b):
#  Tol = 1e-6
#  MaxN = 12
#
#  #FIXME
#  #SRmat = [][]
#
#  Iterating = 0
#  Done = 1
#  SRvec = Srule(F,A,B,Tol)
#  for k in range(len(SRvec)):
#    SRmat[0][k] = SRvec[k]
#  M = 1
#  State = Iterating
#  while (State == Iterating):
#    N = M
#    for j in range(N, 1, -1):
#      Refine(j,SRmat,M,State)
#  Sum1 = 0
#  Sum2 = 0
#  for j in range(M):
#    Sum1 = Sum1 + SRmat[j][7]
#    Sum2 = Sum2 + abs(SRmat[j][8])
#  Integral = Sum1
#  ErrBdd = Sum2
#
#  # end asimp
#
#def Refine(P,SRmat,M,State):
#  Iterating = 0
#  Done = 1
#  State = Done
#  for k in range(11):
#    SR0vec[k] = SRmat[P][k]
#  A = SR0vec[0]
#  C = SR0vec[1]
#  B = SR0vec[2]
#  Fa = SR0vec[3]
#  Fc = SR0vec[4]
#  Fb = SR0vec[5]
#  S = SR0vec[6]
#  S2 = SR0vec[7]
#  Err = SR0vec[8]
#  Tol = SR0vec[9]
#  Check = SR0vec[10]
#  if (Check == 1):
#    return
#  Tol2 = Tol / 2
#  SR1vec = Srule(F, A, C, Tol2)
#  SR2vec = Srule(F, C, B, Tol2)
#  Err = abs(SR0vec[6] - SR1vec[6] - SR2vec[6]) / 10.0
#  if (Err < Tol):
#    SR0vec[11] = 1
#  if (Err < Tol):
#    for k in range(11):
#      SRmat[P][k] = SR0vec[k]
#    SRmat[P][7] = SR1vec[6] + SR2vec[6]
#    SRmat[P][8] = Err
#  else:
#    for j in range(M+1, P, -1):
#      for k in range(11):
#	SRmat(j, k) = SRmat(j - 1, k)
#    M = M + 1
#    for k in range(11):
#      SRmat(P, K) = SR1vec(K)
#    for k in range(11):
#      SRmat[P + 1][K] = SR2vec[K]
#    State = Iterating
#
#def Srule(F,A,B,Tol0,SRvec):
#  H = (B - A) / 2
#  C = (A + B) / 2
#  Fa = F(A)
#  Fc = F(C)
#  Fb = F(B)
#  S = H * (F(A) + 4 * F(C) + F(B)) / 3
#  S2 = S
#  Tol1 = Tol0
#  Err = Tol0
#  Check = 0
#  SRvec[0] = A
#  SRvec[1] = C
#  SRvec[2] = B
#  SRvec[3] = Fa
#  SRvec[4] = Fc
#  SRvec[5] = Fb
#  SRvec[6] = S
#  SRvec[7] = S2
#  SRvec[8] = Err
#  SRvec[9] = Tol1
#  SRvec[10] = Check
#  return SRvec
