#!/usr/bin/python
from math import exp
from gamma import gammln
from quadrature import sinc_ftest, trap

import sys

def test_F_int(t, nu1, nu2):
  C = exp(gammln((nu1+nu2)/2.0) - gammln(nu1/2.0) - gammln(nu2/2.0))
  C = C * (nu1/nu2)**(nu1/2.0)

  # integral
  (I, err) = sinc_ftest(t, nu1, nu2)

  print "I:%e C:%e"%(I, C)
  I = I * C

  I2 = trap(t, nu1, nu2)
  I2 = I2 * C
  print "I2:%e C:%e"%(I2, C)

#  print "TRAP: %e SINC: %e"%(I2, I)

  return (I, err)

# main
t = float(sys.argv[1])
nu1 = float(sys.argv[2])
nu2 = float(sys.argv[3])

print "t:%e v1:%e v2:%e"%(t, nu1, nu2)

print test_F_int(t, nu1, nu2)
