# Fit exponential to a station
from math import *
import marquardt

def y(x, a):
  z = a[0] + a[1]*exp(-1*a[2]*x)
  return z

def dy(x, a):
  # compute dy/da[] for each a, and store in vector
  z = [0.0, 0.0, 0.0]

  z[0] = 1.0
  z[1] = exp(-1*a[2]*x)
  z[2] = -1*a[1]*x*exp(-1*a[2]*x)

  return z

def station_fit(r, t, s, a, eps=1e-5):
  # fit y(t) to exponential, and return coefficients of fit

  # we fit to 3 parameters, a[0], a[1], a[2]
  ia = [1,1,1]

  return marquardt.fit(t, r, s, a, ia, y, dy, eps)
