### FIXME


##
## File operations for exploration.py, based on fileop.py
##

import sys, string, re, time
import jd
from grav_util import Truth, num_sort
from grav_data import *

def readData(fname, write=sys.stdout):
  data = {}; n=0;
  file = open(fname, "rt")
  #lines = file.readlines()
  write("--> found ");
  for line in file:
    line = line.strip()
    if not line: continue
    if line[0] == "#": continue
    # parse exploration format:
    # name lon lat elev gravity sigma iztc ttc comments/ignore
    #fld 0   1   2    3   4      5      6   7   8
    fields = line.split(None)
    key = fields[0]
    data[key] = ExplorationStn()
    data[key].station_id = key
    data[key].lon = to_float(fields[1])
    data[key].lat = to_float(fields[2])
    data[key].elev = to_float(fields[3])
    data[key].gravity = to_float(fields[4])
    data[key].sigma = to_float(fields[5])
    data[key].iztc = to_float(fields[6])
    data[key].ttc = to_float(fields[7])
    n+=1;
    if n%100==0: write("%8d\b\b\b\b\b\b\b\b"%n);
  file.close()
  write("\n--> %d stations\n"%len(data));
  return data

def writeData(out_name, data, options):
  try:
    file = open(out_name, "wt")
  except:
    return False

  file.write("#%-24s %11s %11s %11s %12s %5s %8s %8s"%("Station_id",
    "Longitude", "Latitude", "Elevation", "Gravity", "Sigma", "IZTC", "TTC"));
  rhos = options["densities"].keys();
  rhos.sort(num_sort)
  for rho in rhos:
    file.write(" %9.0f"%rho)
  file.write("\n");
  stns = data.keys()
  #stns.sort()
  for k in stns:
    file.write("%-25s %11.6f %11.6f %11.3f %12.3f %5.3f %8.3f %8.3f"%(data[k].station_id,
      data[k].lon, data[k].lat, data[k].elev, data[k].gravity, data[k].sigma, data[k].iztc,
      data[k].ttc))
    for rho in rhos:
      file.write(" %9.3f"%data[k].cbga[rho])
    file.write("\n");
  file.close()

  return True


def grokCmdFile(name):
   # read and parse command file
   options = defaultOptions()

   comment = re.compile("^[ \t]*#")

   try:
     file = open(name, "rt")
   except:
     return {}
   if not file:
     return {}

   lines = file.readlines()
   file.close()
   for line in lines:
     # strip newline, leading whitespace
     line = line.strip();
     if comment.search(line):
       # comment line, toss
       continue
     # split and parse
     try:
       (key, val) = line.split(None, 1)
     except ValueError:
       F = line.split()
       key = F[0]
       val = ""
     if key == "densities" and val != "":
       # parse into dict
       val = parse_comma_dict(val)
#     if key == "gmt_offset":
#       val = to_float(val)
#
#     if key == "thiele_filt_radius":
#       val = int(to_float(val))

     options[key] = val
   return options

def writeCmdFile(name, options):
  # write out cmd file from options
  # open file
  out = open(name, "wt")
  if not out:
    return 0

  # dump the option database, which has it all
  k = options.keys()
  k.sort()
  for i in k:
    if i == "densities":
      out.write("%-20s\t"%i);
      for j in options[i].keys():
        out.write("%s,"%j)
      out.write("\n");
    else:
      if options[i] == "":
        options[i] = "0"
      out.write("%-20s\t%s\n"%(i, options[i]))

  out.close()
  return 1


def parse_num_tuple(val):
  cut = re.compile("\s*[[(]?([0-9.]*),\s*([0-9.]*),\s*([0-9.]*)[])]?")
  F = cut.search(val).groups()
  a = F[0]; b = F[1]; c = F[2]
  a = to_float(a); b = to_float(b); c = to_float(c)
  val = [a, b, c]
  return val

def parse_comma_dict(val):
  D={}
  F = string.split(val, ",")
  for f in F:
    if f == "": continue
    D[float(f)] = 1
  return D

def to_float(string):
  # wrapper around float()
  if not string or string == "None":
    string = "0"
  try:
    V = float(string)
  except ValueError:
    raise ValueError, "Invalid value %s"%string
  return V

def defaultOptions():
  # return a dict with all the options set to default values
  o = {};
  o["raw_file"]=            	"DIR/INPUT"
  o["out_file"]=            	"DIR/INPUT"
  o["densities"]= {2670:1}
  return(o);

