#!/usr/bin/python
# earthtide - Earth Tide Corrections for file of date/time entries at
# specified lat, lon, elevation, and GMT offset
#
# Use the best formulas we can; this turns out to be Tamura's correction
# scheme

import sys
import jd
import etc

# main routine
def main():
  if len(sys.argv)<6:
    print "usage: earthtide.py <file> <lat> <lon> <ele> <GMT off>"
    print "<file> is a list of dates & times, one per line, as YYYY/MM/DD HH:MM:SS"
    sys.exit(1)

  file = open(sys.argv[1], "rt")
  lines = file.readlines()
  file.close()

  lat = float(sys.argv[2])
  lon = float(sys.argv[3])
  ele = float(sys.argv[4])
  gmt = float(sys.argv[5])

  print "# Earth Tide corrections from Tamura (1989), in mGal"
  print "# computed for: %.6f N, %.6f E, %.3f m ASL, GMT%+.1f hrs"%(lat, lon, ele, gmt)

  # parse the data file
  for line in lines:
    line = line.strip()
    if not line:
      print 
      continue
    if line[0] == "#":
      print line
      continue
    fields = line.split()
    day = jd.str2jd(fields[0], fields[1])
    C = correction(day, lat, lon, ele, gmt)
    print "%-20s %10.3f"%(line, C)

def correction(date, lat, lon, ele, gmt):
  # compute Tamura ETC
  (year, month, day, hour, minute, second)=jd.un_jday(date)

  C = etc.tide(year, month, day, hour, minute, second,
    lon, lat, ele, 0.0, gmt)

  # Tamura's routine yields results in microgal!
  return C/1000.0

main()
