#!/usr/bin/python
#
# Type in tilts, readings, and get back tilt zero error for CG-3
# update....

# need:
# X1 =  150+-10 arcsec ==> R1 in mGal
# X2 = -150+-10 arcsec ==> R2 in mGal
# x_err = (R2-R1)/(X1-X2)*43386
#
# adjust to X2'=X2+x_err, CCW increases tilt value 2.5 arcsec/rev
#
# similar for Y

print "********************************************"
print "*** CG-3(M) Tilt Zero Adjustment Program ***"
print "*** v1.0 Feb 2012  Paul Gettings, U Utah ***"
print "********************************************"

print "Will adjust X, then Y.  Set the reading time to 60 or 120 s."
print "CG-3 should have plenty of power, and be on a concrete or other"
print "sturdy floor."
print
print "You will need small screwdrivers to remove the faceplate and turn"
print "the fine (and maybe coarse) zero adjustment potentiometers. See manual"
print "for location of X and Y pots under faceplate."
print
print "MEASURE X TILT ZERO ERROR"
print 
print "Set meter to tilts: Y=0+-5, X=150+-10"
instr = raw_input("Enter X tilt value: ")
X1 = float(instr)
print "Take a 60 or 120 s reading."
instr = raw_input("Enter gravity value from memory: ")
R1 = float(instr)

print "Set meter to tilts: Y=0+-5, X=-150+-10"
instr = raw_input("Enter X tilt value: ")
X2 = float(instr)
print "Take a 60 or 120 s reading."
instr = raw_input("Enter gravity value from memory: ")
R2 = float(instr)

Xerr = (R2-R1)/(X1-X2)*43386.0
print "X error (arcsec): %.1f"%Xerr

print "Adjust X tilt zero with pots; if meter tilt hasn't moved, adjust"
print "pot (2.5 arcsec/rev, CCW increases tilt reading!) until"
print "X tilt = %.0f+%.1f = %.0f"%(X2,Xerr,X2+Xerr)

instr=raw_input("Press return to continue....")

print "MEASURE Y TILT ZERO ERROR"
print 
print "Set meter to tilts: Y=150+-10, X=0+-5"
instr = raw_input("Enter Y tilt value: ")
Y1 = float(instr)
print "Take a 60 or 120 s reading."
instr = raw_input("Enter gravity value from memory: ")
R1 = float(instr)

print "Set meter to tilts: Y=-150+-10, X=0+-5"
instr = raw_input("Enter Y tilt value: ")
Y2 = float(instr)
print "Take a 60 or 120 s reading."
instr = raw_input("Enter gravity value from memory: ")
R2 = float(instr)

Yerr = (R2-R1)/(Y1-Y2)*43386.0
print "Y error (arcsec): %.1f"%Yerr

print "Adjust Y tilt zero with pots; if meter tilt hasn't moved, adjust"
print "pot (2.5 arcsec/rev, CCW increases tilt reading!) until"
print "Y tilt = %.0f+%.1f = %.0f"%(Y2,Yerr,Y2+Yerr)

