# Status_window - create a Tk window that gets status information, but
# doesn't allow for editing

from Tkinter import *
from tkFont import *

class StatusWindow:
  def __init__(self, master, w=80, h=20):
    self.__master = master
    self.frame = Frame(master, relief="flat")
    self.__font = Font(family="Courier", size=12)
    self.font_width = self.__font.measure("A")
    self.font_height= self.__font.metrics("linespace")
    self.__window = Text(self.frame, state=DISABLED)
    self.__window.config(font=self.__font)
    self.__window.config(width=w)
    self.__window.config(height=h)
    self.__width = w
    self.__height = h
    self.__window.config(wrap=WORD)

    # add a scrollbar
    self.__sb = Scrollbar(self.frame, orient="vertical")
    self.__window.config(yscrollcommand=self.__sb.set)
    self.__sb.config(command=self.__window.yview)
    self.__sb.pack(side=RIGHT, fill="y")
    self.__window.pack(side=LEFT, fill="both", expand=1)

    self.show()

    self.__master.update()
    self.__master.update_idletasks()
    self.hborder = self.__master.winfo_width() - (self.__width*self.font_width)
    self.vborder = self.__master.winfo_height()- (self.__height*self.font_height)

    self.frame.bind("<Configure>", self.resize)

  def show(self, **gridargs):
    self.frame.grid(gridargs)

  def resize(self, event):
    w = (self.__master.winfo_width() - self.hborder)  / self.font_width
    h = (self.__master.winfo_height() - self.vborder) / self.font_height
    self.__window.config(width=w)
    self.__window.config(height=h)
    self.__width = w
    self.__height = h

  def clear(self):
    self.delete(0.0,END)
    self.update()

  def write(self, text):
    self.insert(END, text)

  def insert(self, position, text):
    self.__window.config(state=NORMAL)
    self.__window.insert(position, text)
    self.__window.config(state=DISABLED)
    # make sure the inserted text is visible
    self.__window.see(position)
    #self.update()

  def insertWidget(self, position, widget):
    self.__window.config(state=NORMAL)
    self.__window.window_create(position, window=widget)
    self.__window.config(state=DISABLED)
    # make sure the inserted text is visible
    self.__window.see(position)

  def delete(self, start, end):
    self.__window.config(state=NORMAL)
    self.__window.delete(start, end)
    self.__window.config(state=DISABLED)
    self.update()

  def replace(self, line, text):
    self.delete("%d.0"%line, "%d.end"%line)
    self.insert("%d.0"%line, text)
    self.update()

  def update(self):
    self.__window.update()

  def dump(self):
    return(self.__window.get(0.0, END))

  def getText(self):
    return self.__window

  def getPixelWidth(self):
    return self.__window.cget("width")

