/*
 * xmalloc.c
 *
 * Versions of malloc and friends that check their results, and never return
 * failure (they call fatal if they encounter an error).
 *
 * Taken from Tatu Ylonen's SSH 1.2.12 and slightly adapted.

  Covered by ssh-1.2.12-COPYING

 * 16 Jan 1996, hot@informatik.tu-chemnitz.de
 */

#include <stdio.h>
#include <sys/types.h>
#include "log-server.h"
#include "xmalloc.h"

void *xmalloc(size_t size)
{
  void *ptr = malloc(size);
  if (ptr == NULL)
    fatal("xmalloc: out of memory (allocating %d bytes)", (int)size);
  return ptr;
}

void *xrealloc(void *ptr, size_t new_size)
{
  void *new_ptr;

  if (ptr == NULL)
    fatal("xrealloc: NULL pointer given as argument");
  new_ptr = realloc(ptr, new_size);
  if (new_ptr == NULL)
    fatal("xrealloc: out of memory (new_size %d bytes)", (int)new_size);
  return new_ptr;
}

void xfree(void *ptr)
{
  if (ptr == NULL)
    fatal("xfree: NULL pointer given as argument");
  free(ptr);
}

char *xstrdup(const char *str)
{
  char *cp = xmalloc(strlen(str) + 1);
  strcpy(cp, str);
  return cp;
}
