/*
 * unregister an RPC procedure with the portmapper
 *
 * 11 Feb 1996, hot@informatik.tu-chemnitz.de
 */

#include <stdio.h>
#include <rpc/rpc.h>

/*
 * show the usage
 */
void usage(void)
{
  fprintf(stderr, "usage: pmap_unset rpc_prog rpc_vers\n");
  exit(1);
}

/*
 * MAIN
 */
int
main(int argc, char **argv)
{
    unsigned long rpc_prog, rpc_vers;

    if (argc != 3)
    {
      usage();
    }

    rpc_prog = atoi(argv[1]);
    rpc_vers = atoi(argv[2]);

    if (!pmap_unset(rpc_prog, rpc_vers, IPPROTO_TCP))
    {
      fprintf(stderr, "pmap_unset failed\n");
      exit(1);
    }
    exit(0);
}
