/*
 * register an RPC procedure with the portmapper (TCP)
 *
 * 11 Feb 1996, hot@informatik.tu-chemnitz.de
 */

#include <stdio.h>
#include <rpc/rpc.h>

/*
 * show the usage
 */
void usage(void)
{
  fprintf(stderr, 
          "usage: pmap_set rpc_prog rpc_vers [start_port [end_port]]\n");
  fprintf(stderr, 
          "       start_port and end_port specify a port range\n");
  exit(1);
}

/*
 * MAIN
 */
int
main(int argc, char **argv)
{
    unsigned long rpc_prog, rpc_vers;
    unsigned short int port, maxp;

    if (argc < 3 || argc > 5)
    {
      usage();
    }

    rpc_prog = atol(argv[1]);
    rpc_vers = atol(argv[2]);
    port = (argc > 3) ? atoi(argv[3]) : 1024;
    maxp = (argc > 4) ? atoi(argv[4]) : port;

    if (maxp < port)
    {
      fprintf(stderr, "empty port range!!, aborting\n");
      exit(1);
    }

    /* search for a good TCP port in the port range */
  
    while (port <= maxp && !pmap_set(rpc_prog, rpc_vers, IPPROTO_UDP, port))
    {
      port++;
    }
  
    if (port > maxp)
    {
      fprintf(stderr, "no free port\n");
      exit(1);
    }
    else
    {
      printf("%d\n", port);
    }
    exit(0);
}
