/*

strerror.c

Author: Tatu Ylonen <ylo@cs.hut.fi>

Copyright (c) 1995 Tatu Ylonen <ylo@cs.hut.fi>, Espoo, Finland
                   All rights reserved

Created: Wed Mar 22 18:18:21 1995 ylo

Covered by ssh-1.2.12-COPYING

Replacement for strerror for systems that don't have it.

*/

/*
 * $Id: strerror.c,v 1.2 1995/07/13 01:40:55 ylo Exp $
 * $Log: strerror.c,v $
 * Revision 1.2  1995/07/13  01:40:55  ylo
 * 	Removed "Last modified" header.
 * 	Added cvs log.
 *
 * $Endlog$
 */

#include <stdio.h>
#include <errno.h>

#include "config.h"

#ifndef HAVE_STRERROR

extern char *sys_errlist[];
extern int sys_nerr;

char *strerror(int error_number)
{
  if (error_number >= 0 && error_number < sys_nerr)
    return (char *) sys_errlist[error_number];
  else
    return NULL;
}

#endif
