/*
 * servconf.h
 *
 * Definitions for server configuration data and for the functions handling it.
 * 
 * 13 Feb 1996, hot@informatik.tu-chemnitz.de
 */

#ifndef SERVCONF_H
#define SERVCONF_H

#include <sys/types.h>
#include <netinet/in.h>
#include <pwd.h>
#include <grp.h>

#include "config.h"

#define MAX_FORWARD 50         /* Max # of RPC services to be forwarded */
#define MAX_ARGS 100
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 500
#endif
#define MAX_ID      50         /* Max number of accepted id */
#define MAX_TRUSTED 5          /* Max number of trusted uid */

typedef struct
{
  u_long prog;           /* RPC program number */
  u_long vers;           /* RPC version number */
  u_long remote_prog;    /* distant RPC program number */
  u_int num_uid;         /* number of acceptable uid */
  u_int num_gid;         /* number of acceptable gid */
  uid_t uid[MAX_ID];     /* acceptable uid */
  gid_t gid[MAX_ID];     /* acceptable gid */
  int flags;             /* numerous flags */
  int old_port;          /* old port registered with portmap for prog,vers */
} forward;

#define SEC_RPC_SET         0x0001 /* has the RPC program been registered */
                                   /* with portmap ?*/
#define SEC_RPC_TO_REGISTER 0x0002 /* has this program to be registered */
#define SEC_RPC_ACCEPTED    0x0004 /* is this program accepted in the rpc requests */
#define SEC_RPC_ANY_UID     0x0010 /* accept any uid */
#define SEC_RPC_ANY_GID     0x0020 /* accept any gid */
#define SEC_RPC_UNSET_PMAP  0x0040 /* unset portmap entry even if KeepPortmap
                                      is set */
#define SEC_RPC_REGISTERED  0x0100 /* is the RPC program already registered
                                      with the right port ? */

typedef struct
{
  char *ssh_command;           /* ssh command to be executed */
  u_int udp_port;              /* UDP port on which the proxy listens */
  forward                      /* services to be forwarded via UDP */
    udp_forward[MAX_FORWARD];  /* or accepted as rpc requests */
  u_int num_udp_fw;            /* number of entries in udp_forward */
  struct in_addr listen_addr;  /* address on which the server listens */
  u_int with_magic;              /* if true, use a magic value in each packet */
  u_long packet_magic;         /* magic value to check the synchronization */
  u_int max_ref_count;         /* maximum reference count per XID mapping */
  char *id_string;             /* ID string expected from the remote side */
  u_int quiet_mode;              /* if true, don't log anything but fatals */
  u_int log_to_syslog;           /* if false, suppress logging to syslog */
  u_int log_facility;            /* facility for system logging */
  u_int insecure_mode;           /* no security checks, if set overrides */
                                 /* insecure_port and insecure_msg*/
  u_int insecure_port;           /* accepts non priviledged ports connections */
  u_int insecure_msg;            /* no check on rpc credentials */
  u_int show_msg;                /* show rpc message content in debug mode */
  u_int keep_pmap;               /* keep portmapper entries as far as possible */
  u_int retry_ssh;               /* retry ssh connection */
  u_int retry_limit;             /* nb of ssh retry before giving up. 0 = never */
  u_int reap_interval;         /* reap XID mappings after reap_interval secs */
  char * id;               /* id corresponding with the uid to be used by the server*/ 
  char * tunnel_command;        /* command used to make the tunnel, default is ssh*/
  char *host;                    /* remote host */
  char *remote_id;               /* which id to connect as on the remote host */
  char *remote_command;          /* remote command executed on the remote host, default is rpc_pcl */
} ServerOptions;

typedef struct 
{
  uid_t trusted_uid[MAX_TRUSTED];   /* trusted uid allowed to tunnel anything */
  u_int num_trusted_uid;            /* number of entries in trusted_uid */
  forward 
    accepted_forward[MAX_FORWARD];  /* services, uid, gid... accepted */
  u_int num_acc_fw;                 /* number of entries in accepted_forward */
  u_int insecure;                   /* if true, don't do any security check */
  u_int show_msg;                   /* show rpc message content in debug mode */
  u_int log_to_syslog;              /* if false, suppress logging to syslog */
  u_int quiet;                      /* if false no logging */
} ClntOptions;

/* Read the server configuration file. */
void read_server_config(ServerOptions *options, const char *filename);

/* Initializes the server options to their default values. */
void fill_default_server_options(ServerOptions *options);

/* parse a command line, breaking it in words with \ protecting next char */
void parse_command(char * command, char **arg);

/* duplicate a command line */
int duplicate_command(char** to_command, char** from_command);

/* return the size of a command */
int size_command(char** command);

/* join added_command to resul_command */
int join_commands(char **result_command, char** added_command);

/* concatenate comand lines */
void concatenate_commands(char ** result_command, int number, ...);

/* debug command line */
void debug_command(char **command);

u_int parse_gid_list(char *string, gid_t *gid_table, u_int num_uig);
u_int parse_uid_list(char *string, uid_t *uid_table, u_int num_uid);

void debug_uid_list(uid_t *uid_list, u_int num_uid);
void debug_gid_list(gid_t *gid_list, u_int num_gid);

void dump_forward(forward *msg_forward, u_int num_fw);



/* Read rpc_pcl configuration file */
void read_rpc_pcl_config(ClntOptions *options);

/* Initializes the server options to their default values. */
void fill_default_rpc_pcl_options(ClntOptions *options);

#endif /* SERVCONF_H */
